/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.tablecolumn;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.field.table.TableColumnNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.buttongroup.ButtonGroup;
import org.eclipse.scout.sdk.ui.fields.buttongroup.IButtonGroupListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.ScoutWizardDialog;
import org.eclipse.scout.sdk.ui.wizard.tablecolumn.TableColumnNewWizard;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DefaultTableColumnNewWizardPage
extends AbstractWorkspaceWizardPage {
    private INlsEntry m_nlsName;
    private String m_typeName;
    private String m_genericSignature;
    private SiblingProposal m_sibling;
    private TableColumnNewWizard.CONTINUE_OPERATION m_continueOperation;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private IType m_superType;
    private IType m_createdColumn;

    public DefaultTableColumnNewWizardPage(IType declaringType, TableColumnNewWizard.CONTINUE_OPERATION op) {
        super(DefaultTableColumnNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewTableColumn"));
        this.setDescription(Texts.get((String)"CreateANewTableColumn"));
        this.m_genericSignature = SignatureCache.createTypeSignature((String)Long.class.getName());
        this.m_declaringType = declaringType;
        this.m_sibling = SiblingProposal.SIBLING_END;
        this.m_continueOperation = op;
    }

    @Override
    protected void createContent(Composite parent) {
        this.createFieldGroup(parent);
        this.createNextStepsGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, false));
    }

    private void createNextStepsGroup(Composite p) {
        Group g = new Group(p, 0);
        g.setText(Texts.get((String)"NextStep"));
        g.setLayout((Layout)new GridLayout(1, false));
        g.setLayoutData((Object)new GridData(768));
        ButtonGroup nextStepOptions = new ButtonGroup((Composite)g, 16);
        nextStepOptions.createButton(Texts.get((String)"CreateMoreColumn"), TableColumnNewWizard.CONTINUE_OPERATION.ADD_MORE_COLUMNS);
        nextStepOptions.createButton(Texts.get((String)"FinishWizard"), TableColumnNewWizard.CONTINUE_OPERATION.FINISH);
        nextStepOptions.addButtonGroupListener(new IButtonGroupListener<TableColumnNewWizard.CONTINUE_OPERATION>(){

            @Override
            public void handleSelectionChanged(List<TableColumnNewWizard.CONTINUE_OPERATION> newSelection) {
                DefaultTableColumnNewWizardPage.this.m_continueOperation = newSelection.get(0);
            }
        });
        nextStepOptions.setValue(this.m_continueOperation);
        nextStepOptions.setLayoutData(new GridData(768));
    }

    private void createFieldGroup(Composite p) {
        Group fieldGroup = new Group(p, 0);
        fieldGroup.setText(Texts.get((String)"Column"));
        INlsProject nlsProject = ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType);
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField((Composite)fieldGroup, nlsProject, Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    DefaultTableColumnNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = DefaultTableColumnNewWizardPage.this.getNlsName();
                    DefaultTableColumnNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (DefaultTableColumnNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(DefaultTableColumnNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)DefaultTableColumnNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        DefaultTableColumnNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)DefaultTableColumnNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    DefaultTableColumnNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField((Composite)fieldGroup, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Column");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DefaultTableColumnNewWizardPage.this.m_typeName = DefaultTableColumnNewWizardPage.this.m_typeNameField.getText();
                DefaultTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField((Composite)fieldGroup, Texts.get((String)"GenericType"), ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType));
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                DefaultTableColumnNewWizardPage.this.m_genericSignature = (String)event.proposal;
                DefaultTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createSiblingProposalField((Composite)fieldGroup, this.m_declaringType, TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn"));
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                DefaultTableColumnNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                DefaultTableColumnNewWizardPage.this.pingStateChanging();
            }
        });
        fieldGroup.setLayout((Layout)new GridLayout(1, false));
        fieldGroup.setLayoutData((Object)new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        if (TableColumnNewWizard.CONTINUE_OPERATION.ADD_MORE_COLUMNS == this.m_continueOperation) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TableColumnNewWizard wizard = new TableColumnNewWizard(DefaultTableColumnNewWizardPage.this.m_continueOperation);
                    wizard.initWizard(DefaultTableColumnNewWizardPage.this.m_declaringType);
                    ScoutWizardDialog wizardDialog = new ScoutWizardDialog(wizard);
                    wizardDialog.open();
                }
            });
        }
        TableColumnNewOperation operation = new TableColumnNewOperation(this.getTypeName(), this.m_declaringType, true);
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? SignatureCache.createTypeSignature((String)(String.valueOf(superTypeProp.getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature()) + ">")) : SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName());
            operation.setSuperTypeSignature(sig);
        }
        operation.setNlsEntry(this.getNlsName());
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredTable((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_COLUMN));
        } else {
            operation.setSibling(this.getSibling().getElement());
        }
        operation.validate();
        operation.run(monitor, workingCopyManager);
        this.m_createdColumn = operation.getCreatedColumn();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusNameField());
        multiStatus.add(this.getStatusGenericType());
        if (this.isControlCreated()) {
            this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        }
    }

    protected IStatus getStatusNameField() {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"Column");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return javaFieldNameStatus;
    }

    public IType getCreatedColumn() {
        return this.m_createdColumn;
    }

    protected IStatus getStatusGenericType() {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Generic type can not be null!");
        }
        return Status.OK_STATUS;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            if (TypeUtility.isGenericType((IType)this.getSuperType())) {
                this.setGenericSignature(SignatureCache.createTypeSignature((String)Long.class.getName()));
            } else {
                this.setGenericSignature(null);
            }
            this.m_superType = superType;
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(String genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

