/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsStubGenerationOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ErrorDialog;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IOperationFinishedListener;
import org.eclipse.swt.widgets.MessageBox;

public class StubRebuildCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private String m_alias;
    private Map<String, List<String>> m_properties;
    private WsdlResource m_wsdlResource;

    public StubRebuildCommand(IScoutBundle bundle) {
        super("Webservice stub might be out of date");
        this.m_bundle = bundle;
        this.setSolutionDescription("By using this task, the webservice stub is rebuilt.");
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        WsStubGenerationOperation op = new WsStubGenerationOperation();
        op.setBundle(this.m_bundle);
        op.setAlias(this.m_alias);
        op.setProperties(this.m_properties);
        op.addOperationFinishedListener(new P_OperationFinishedListener());
        op.setWsdlFileName(this.m_wsdlResource.getFile().getName());
        IPath wsdlFolderPath = this.m_wsdlResource.getFile().getProjectRelativePath().removeLastSegments(1);
        op.setWsdlFolder(JaxWsSdkUtility.getFolder(this.m_bundle, wsdlFolderPath, false));
        op.run(monitor, workingCopyManager);
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public Map<String, List<String>> getProperties() {
        return this.m_properties;
    }

    public void setProperties(Map<String, List<String>> properties) {
        this.m_properties = properties;
    }

    public WsdlResource getWsdlResource() {
        return this.m_wsdlResource;
    }

    public void setWsdlResource(WsdlResource wsdlResource) {
        this.m_wsdlResource = wsdlResource;
    }

    private class P_OperationFinishedListener
    implements IOperationFinishedListener {
        private P_OperationFinishedListener() {
        }

        @Override
        public void operationFinished(final boolean success, final Throwable e) {
            StubRebuildCommand.this.m_wsdlResource.notifyStubRebuilt(StubRebuildCommand.this.m_alias);
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (success) {
                        MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 34);
                        messageBox.setMessage(Texts.get("WsStubSuccessfullyGenerated"));
                        messageBox.open();
                    } else {
                        ErrorDialog dialog = new ErrorDialog(Texts.get("StubGenerationFailed"));
                        dialog.setError(Texts.get("WsStubGenerationFailed"), e);
                        dialog.open();
                    }
                }
            });
        }
    }
}

