/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.action;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.BindingFileCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.AbstractLinkAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.util.GlobalBindingRegistrationHelper;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.swt.widgets.Shell;

public class BindingFileNewAction
extends AbstractLinkAction {
    private BuildJaxWsBean m_buildJaxWsBean;
    private IScoutBundle m_bundle;
    private WsdlResource m_wsdlResource;

    public BindingFileNewAction() {
        super(Texts.get("AddBindingFile"), ScoutSdkUi.getImageDescriptor((String)"add.png"));
        this.setLinkText(Texts.get("AddBindingFile"));
        this.setToolTip(Texts.get("TooltipBindingFileNew"));
    }

    public void init(IScoutBundle bundle, BuildJaxWsBean buildJaxWsBean, WsdlResource wsdlResource) {
        this.m_buildJaxWsBean = buildJaxWsBean;
        this.m_bundle = bundle;
        this.m_wsdlResource = wsdlResource;
    }

    public boolean isVisible() {
        return !this.m_bundle.isBinary();
    }

    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        GlobalBindingRegistrationHelper.SchemaCandidate schemaCandidate;
        block5: {
            schemaCandidate = null;
            try {
                schemaCandidate = GlobalBindingRegistrationHelper.popupForSchema(this.m_wsdlResource.getFile());
            }
            catch (CoreException e) {
                if (e.getStatus() == null || e.getStatus().getCode() != Status.CANCEL_STATUS.getCode()) break block5;
                return null;
            }
        }
        BindingFileCreateOperation op = new BindingFileCreateOperation();
        if (schemaCandidate != null) {
            SchemaUtility.WsdlArtifact<IFile> wsdlArtifact = schemaCandidate.getWsdlArtifact();
            if (wsdlArtifact.getInlineSchemas().length > 1) {
                op.setSchemaTargetNamespace(SchemaUtility.getSchemaTargetNamespace(schemaCandidate.getSchema()));
            }
            if (wsdlArtifact.getTypeEnum() == SchemaUtility.WsdlArtifact.TypeEnum.ReferencedWsdl) {
                op.setWsdlLocation((IFile)wsdlArtifact.getFileHandle().getFile());
            }
        }
        IPath bindingFilePath = JaxWsSdkUtility.toUniqueProjectRelativeBindingFilePath(this.m_bundle, this.m_buildJaxWsBean.getAlias(), op.getSchemaTargetNamespace());
        Map<String, List<String>> properties = this.m_buildJaxWsBean.getPropertiers();
        JaxWsSdkUtility.addBuildProperty(properties, "b", bindingFilePath.toString());
        op.setBundle(this.m_bundle);
        op.setProjectRelativePath(bindingFilePath);
        op.setWsdlDestinationFolder(JaxWsSdkUtility.getParentFolder(this.m_bundle, this.m_wsdlResource.getFile()));
        op.setCreateGlobalBindingSection(!JaxWsSdkUtility.containsGlobalBindingSection(this.m_bundle, properties, false));
        new OperationJob(new IOperation[]{op}).schedule();
        this.m_buildJaxWsBean.setProperties(properties);
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXmlAsync(this.m_buildJaxWsBean.getXml().getOwnerDocument(), 8, this.m_buildJaxWsBean.getAlias());
        return null;
    }
}

