/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuildJaxWsBean {
    public static final String XML_PROVIDER = "provider";
    public static final String XML_CONSUMER = "consumer";
    public static final String XML_ALIAS = "name";
    public static final String XML_PROPERTY = "property";
    public static final String XML_PROPERTY_NAME = "name";
    public static final String XML_PROPERTY_VALUE = "value";
    public static final String XML_WSDL = "wsdl";
    private Element m_xml;
    private WebserviceEnum m_webserviceEnum;

    public BuildJaxWsBean(Element xml, WebserviceEnum webserviceEnum) {
        this.m_xml = xml;
        this.m_webserviceEnum = webserviceEnum;
    }

    public Element getXml() {
        return this.m_xml;
    }

    public void setXml(Element xml) {
        this.m_xml = xml;
    }

    public String getAlias() {
        return JaxWsSdkUtility.getXmlAttribute(this.m_xml, "name", null);
    }

    public void setAlias(String alias) {
        this.m_xml.removeAttribute("name");
        this.m_xml.setAttribute("name", alias);
    }

    public void setWsdl(String wsdl) {
        this.m_xml.removeAttribute(XML_WSDL);
        this.m_xml.setAttribute(XML_WSDL, wsdl);
    }

    public String getWsdl() {
        return JaxWsSdkUtility.getXmlAttribute(this.m_xml, XML_WSDL, null);
    }

    public Map<String, List<String>> getPropertiers() {
        HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
        List<Element> children = JaxWsSdkUtility.getChildElements(this.m_xml.getChildNodes(), XML_PROPERTY);
        for (Element xmlProperty : children) {
            String name = JaxWsSdkUtility.getXmlAttribute(xmlProperty, "name", null);
            if (StringUtility.isNullOrEmpty((String)name)) continue;
            String value = JaxWsSdkUtility.getXmlAttribute(xmlProperty, XML_PROPERTY_VALUE, null);
            if (!properties.containsKey(name)) {
                properties.put(name, new LinkedList());
            }
            ((List)properties.get(name)).add(value);
        }
        return properties;
    }

    public void setProperties(Map<String, List<String>> properties) {
        JaxWsSdkUtility.removeAllChildElements(this.m_xml, XML_PROPERTY);
        if (properties == null || properties.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> property : properties.entrySet()) {
            String name = property.getKey();
            if (property.getValue() == null || property.getValue().size() == 0) {
                Element xmlProperty = this.m_xml.getOwnerDocument().createElement(XML_PROPERTY);
                xmlProperty.setAttribute("name", property.getKey());
                this.m_xml.appendChild(xmlProperty);
                continue;
            }
            for (String value : property.getValue()) {
                Element xmlProperty = this.m_xml.getOwnerDocument().createElement(XML_PROPERTY);
                xmlProperty.setAttribute("name", name);
                xmlProperty.setAttribute(XML_PROPERTY_VALUE, value);
                this.m_xml.appendChild(xmlProperty);
            }
        }
    }

    public boolean reload(IScoutBundle bundle) {
        Document newDocument = ResourceFactory.getBuildJaxWsResource(bundle).loadXml();
        if (newDocument == null) {
            return false;
        }
        Element rootXml = newDocument.getDocumentElement();
        if (rootXml == null) {
            return false;
        }
        String nodeName = this.m_webserviceEnum == WebserviceEnum.Provider ? XML_PROVIDER : XML_CONSUMER;
        List<Element> xml = JaxWsSdkUtility.getChildElementsWithAttributes(rootXml, nodeName, "name", this.getAlias());
        if (xml.size() < 1) {
            return false;
        }
        this.setXml(xml.get(0));
        return true;
    }

    public static BuildJaxWsBean load(IScoutBundle bundle, String alias, WebserviceEnum webserviceEnum) {
        if (!StringUtility.hasText((String)alias)) {
            return null;
        }
        Document document = ResourceFactory.getBuildJaxWsResource(bundle).loadXml();
        if (document == null) {
            return null;
        }
        String nodeName = webserviceEnum == WebserviceEnum.Provider ? XML_PROVIDER : XML_CONSUMER;
        Element rootXml = document.getDocumentElement();
        if (rootXml == null) {
            return null;
        }
        List<Element> xml = JaxWsSdkUtility.getChildElementsWithAttributes(rootXml, nodeName, "name", alias);
        if (xml.size() < 1) {
            return null;
        }
        return new BuildJaxWsBean(xml.get(0), webserviceEnum);
    }
}

