/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class InformationPresenter
extends AbstractPresenter {
    private String m_text;
    private ImageDescriptor m_imageDescriptor;
    private Point m_iconDimension;

    public InformationPresenter(Composite parent, String text, PropertyViewFormToolkit toolkit) {
        this(parent, text, null, null, toolkit);
    }

    public InformationPresenter(Composite parent, String text, ImageDescriptor imageDescriptor, PropertyViewFormToolkit toolkit) {
        this(parent, text, imageDescriptor, new Point(16, 16), toolkit);
    }

    public InformationPresenter(Composite parent, String text, ImageDescriptor imageDescriptor, Point iconDimension, PropertyViewFormToolkit toolkit) {
        super(toolkit, parent);
        this.m_text = text;
        this.m_imageDescriptor = imageDescriptor;
        this.m_iconDimension = iconDimension;
        this.createPresenter();
    }

    public Control createPresenter() {
        Composite presenter = this.getContainer();
        Label icon = new Label(presenter, 0);
        if (this.m_imageDescriptor != null) {
            icon.setImage(ScoutSdkUi.getImage((ImageDescriptor)new JavaElementImageDescriptor(this.m_imageDescriptor, 0, this.m_iconDimension)));
        }
        Label text = new Label(presenter, 64);
        text.setText(this.m_text);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        presenter.setLayout((Layout)layout);
        GridData gd = new GridData();
        boolean bl = gd.exclude = icon.getImage() == null;
        if (icon.getImage() != null) {
            gd.widthHint = this.m_iconDimension.x + 5;
        }
        icon.setLayoutData((Object)gd);
        gd = new GridData(1808);
        text.setLayoutData((Object)gd);
        return presenter;
    }

    public boolean isMultiLine() {
        return false;
    }
}

