/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsdlCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsPropertiesNewWsdlWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;

public class WsdlNewWizard
extends AbstractWorkspaceWizard {
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private BuildJaxWsBean m_buildJaxWsBean;
    private WsdlResource m_wsdlResource;
    private WsPropertiesNewWsdlWizardPage m_wizardPage;
    private String m_alias;
    private WsdlCreateOperation m_operation;

    public WsdlNewWizard(IScoutBundle bundle, SunJaxWsBean sunJaxWsBean, WsdlResource wsdlResource) {
        this.m_bundle = bundle;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_wsdlResource = wsdlResource;
        this.m_alias = this.m_sunJaxWsBean.getAlias();
        this.setWindowTitle(Texts.get("CreateWsdlFile"));
    }

    public WsdlNewWizard(IScoutBundle bundle, BuildJaxWsBean buildJaxWsBean, WsdlResource wsdlResource) {
        this.m_bundle = bundle;
        this.m_buildJaxWsBean = buildJaxWsBean;
        this.m_wsdlResource = wsdlResource;
        this.m_alias = this.m_buildJaxWsBean.getAlias();
        this.setWindowTitle(Texts.get("CreateWsdlFile"));
    }

    public void addPages() {
        this.m_wizardPage = new WsPropertiesNewWsdlWizardPage(this.m_bundle);
        this.m_wizardPage.setShowOnlyWsdlProperties(true);
        this.m_wizardPage.setAlias(this.m_alias);
        this.m_wizardPage.setWsdlName(this.m_wsdlResource.getFile().getName());
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    protected boolean beforeFinish() throws CoreException {
        String targetNamespace = PathNormalizer.toTargetNamespace(this.m_wizardPage.getTargetNamespace());
        this.m_operation = new WsdlCreateOperation();
        this.m_operation.setBundle(this.m_bundle);
        this.m_operation.setAlias(this.m_alias);
        this.m_operation.setWsdlResource(this.m_wsdlResource);
        this.m_operation.setTargetNamespace(targetNamespace);
        this.m_operation.setService(this.m_wizardPage.getServiceName());
        this.m_operation.setPortName(this.m_wizardPage.getPortName());
        this.m_operation.setPortType(this.m_wizardPage.getPortTypeName());
        this.m_operation.setBinding(this.m_wizardPage.getBinding());
        this.m_operation.setUrlPattern(this.m_wizardPage.getUrlPattern());
        this.m_operation.setServiceOperationName(this.m_wizardPage.getServiceOperationName());
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        this.m_operation.validate();
        this.m_operation.run(monitor, workingCopyManager);
        if (this.m_sunJaxWsBean != null) {
            this.m_sunJaxWsBean.setWsdl(PathNormalizer.toWsdlPath(this.m_wsdlResource.getFile().getProjectRelativePath().toString()));
            ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXml(this.m_sunJaxWsBean.getXml().getOwnerDocument(), 16, monitor, this.m_sunJaxWsBean.getAlias());
        } else {
            this.m_buildJaxWsBean.setWsdl(PathNormalizer.toWsdlPath(this.m_wsdlResource.getFile().getProjectRelativePath().toString()));
            ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXml(this.m_buildJaxWsBean.getXml().getOwnerDocument(), 16, monitor, this.m_buildJaxWsBean.getAlias());
        }
        return true;
    }
}

