/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.validator;

import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.eclipse.scout.sdk.ws.jaxws.validator.IServletAliasValidation;

public final class ServletAliasValidator {
    private ServletAliasValidator() {
    }

    public static boolean validate(String servletAlias, IServletAliasValidation validation) {
        if (!StringUtility.hasText((String)servletAlias) || new Path(servletAlias).makeRelative().isEmpty()) {
            validation.onEmpty();
            return false;
        }
        if (!servletAlias.equals(PathNormalizer.toServletAlias(servletAlias))) {
            validation.onWrongSeparators();
            return false;
        }
        if (!servletAlias.matches("[\\w\\-/]*")) {
            validation.onIllegalCharacters();
            return false;
        }
        return true;
    }
}

