/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.service.CreateServiceImmediatelySchedulingRule;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.IServiceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class DefaultServiceFactory
implements IServiceFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultServiceFactory.class);
    private Bundle m_bundle;
    private Class<?> m_serviceClass;
    private Object m_service;
    private Object m_serviceLock = new Object();

    public DefaultServiceFactory(Class<?> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("service type must not be null");
        }
        if (serviceClass.isInterface()) {
            throw new IllegalArgumentException("service type must not be an interface: " + serviceClass);
        }
        this.m_serviceClass = serviceClass;
    }

    @Override
    public void serviceRegistered(final ServiceRegistration registration) throws Throwable {
        Boolean createImmediately = (Boolean)registration.getReference().getProperty("service.createImmediately");
        if (createImmediately != null && createImmediately.booleanValue()) {
            Job job = new Job("create service " + this.m_serviceClass.getSimpleName()){

                protected IStatus run(IProgressMonitor monitor) {
                    DefaultServiceFactory.this.updateClassCache(registration);
                    DefaultServiceFactory.this.updateInstanceCache(registration);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)new CreateServiceImmediatelySchedulingRule());
            job.schedule();
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        this.updateClassCache(registration);
        this.updateInstanceCache(registration);
        return this.m_service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassCache(ServiceRegistration registration) {
        Object object = this.m_serviceLock;
        synchronized (object) {
            if (this.m_bundle == null) {
                this.m_bundle = registration.getReference().getBundle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInstanceCache(ServiceRegistration registration) {
        Object object = this.m_serviceLock;
        synchronized (object) {
            if (this.m_service == null) {
                try {
                    this.m_service = this.m_serviceClass.newInstance();
                    if (this.m_service instanceof IService) {
                        ((IService)this.m_service).initializeService(registration);
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed creating instance of " + this.m_serviceClass, t);
                }
            }
        }
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }
}

