/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.svg.ui.swing.internal;

import java.awt.Component;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.swing.svg.SVGUserAgentGUIAdapter;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.svg.client.JSVGCanvasEx;
import org.eclipse.scout.svg.client.SVGUtility;
import org.w3c.dom.svg.SVGDocument;

public class SwingViewer {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingViewer.class);
    private static final int DEFAULT_FRAME_WIDTH = 800;
    private static final int DEFAULT_FRAME_HEIGHT = 600;

    private SwingViewer() {
    }

    public static void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new SwingViewer(null).runSwing();
                }
                catch (ProcessingException e) {
                    LOG.error("Problem running SwingViewer: ", (Throwable)e);
                }
            }
        });
    }

    private void runSwing() throws ProcessingException {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        SVGUserAgentGUIAdapter ua = new SVGUserAgentGUIAdapter(frame){

            public void openLink(String uri, boolean newc) {
                LOG.debug("USER_AGENT.openLink({0}, {1})", (Object)uri, (Object)newc);
            }
        };
        JSVGCanvasEx canvas = new JSVGCanvasEx((SVGUserAgent)ua, true, false);
        frame.getContentPane().add((Component)canvas, "Center");
        frame.pack();
        frame.setSize(800, 600);
        frame.setVisible(true);
        SVGDocument doc = SVGUtility.readSVGDocument((InputStream)SwingViewer.class.getResourceAsStream("sample.svg"));
        canvas.setDocumentState(1);
        canvas.setSVGDocument(doc);
    }

    /* synthetic */ SwingViewer(SwingViewer swingViewer) {
        this();
    }
}

