/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.prefs;

import org.eclipse.scout.commons.Base64Utility;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractPreferences
implements Preferences {
    private final String m_name;
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public AbstractPreferences(String name) {
        this.m_name = name;
    }

    protected abstract void putImpl(String var1, String var2);

    protected abstract String getImpl(String var1);

    protected abstract void removeImpl(String var1);

    protected abstract void clearImpl();

    public String name() {
        return this.m_name;
    }

    public String[] childrenNames() throws BackingStoreException {
        return new String[0];
    }

    public Preferences parent() {
        return null;
    }

    public Preferences node(String pathName) {
        return null;
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        return false;
    }

    public void removeNode() throws BackingStoreException {
    }

    public String absolutePath() {
        return "/" + this.name();
    }

    public void flush() throws BackingStoreException {
    }

    public void sync() throws BackingStoreException {
    }

    public void clear() throws BackingStoreException {
        this.clearImpl();
    }

    public void remove(String key) {
        this.removeImpl(key);
    }

    public void put(String key, String newValue) {
        this.internalPut(key, newValue);
    }

    public void putBoolean(String key, boolean value) {
        String newValue = value ? TRUE : FALSE;
        this.internalPut(key, newValue);
    }

    public void putByteArray(String key, byte[] value) {
        String newValue = new String(Base64Utility.encode(value));
        this.internalPut(key, newValue);
    }

    public void putDouble(String key, double value) {
        String newValue = Double.toString(value);
        this.internalPut(key, newValue);
    }

    public void putFloat(String key, float value) {
        String newValue = Float.toString(value);
        this.internalPut(key, newValue);
    }

    public void putInt(String key, int value) {
        String newValue = Integer.toString(value);
        this.internalPut(key, newValue);
    }

    public void putLong(String key, long value) {
        String newValue = Long.toString(value);
        this.internalPut(key, newValue);
    }

    public String get(String key, String def) {
        String value = this.internalGet(key);
        return value != null ? value : def;
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.internalGet(key);
        return value != null ? TRUE.equalsIgnoreCase(value) : def;
    }

    public byte[] getByteArray(String key, byte[] def) {
        String value = this.internalGet(key);
        return value != null ? Base64Utility.decode(value) : def;
    }

    public double getDouble(String key, double def) {
        String value = this.internalGet(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public float getFloat(String key, float def) {
        String value = this.internalGet(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public int getInt(String key, int def) {
        String value = this.internalGet(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public long getLong(String key, long def) {
        String value = this.internalGet(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    protected String internalPut(String key, String newValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        String oldValue = this.getImpl(key);
        if (!(newValue == oldValue || newValue != null && newValue.equals(oldValue))) {
            this.putImpl(key, newValue);
        }
        return oldValue;
    }

    protected String internalGet(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getImpl(key);
    }
}

