/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.handler.internal;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.scout.commons.RunnableWithException;
import org.eclipse.scout.jaxws.annotation.ScoutTransaction;
import org.eclipse.scout.jaxws.handler.internal.IScoutTransactionHandlerWrapper;
import org.eclipse.scout.jaxws.internal.ScoutTransactionDelegate;

public class ScoutTransactionSOAPHandlerWrapper<T extends SOAPMessageContext>
implements SOAPHandler<T>,
IScoutTransactionHandlerWrapper<T> {
    protected final ScoutTransactionDelegate m_transactionDelegate;
    protected final SOAPHandler<T> m_soapHandler;

    public ScoutTransactionSOAPHandlerWrapper(SOAPHandler<T> soapHandler, ScoutTransaction scoutTransaction) {
        this.m_transactionDelegate = this.createTransactionDelegate(scoutTransaction);
        this.m_soapHandler = soapHandler;
    }

    public boolean handleMessage(final T context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                return ScoutTransactionSOAPHandlerWrapper.this.m_soapHandler.handleMessage((MessageContext)context);
            }
        };
        return this.m_transactionDelegate.runInTransaction(runnable, (MessageContext)context);
    }

    public boolean handleFault(final T context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                return ScoutTransactionSOAPHandlerWrapper.this.m_soapHandler.handleFault((MessageContext)context);
            }
        };
        return this.m_transactionDelegate.runInTransaction(runnable, (MessageContext)context);
    }

    public void close(final MessageContext context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                ScoutTransactionSOAPHandlerWrapper.this.m_soapHandler.close(context);
                return null;
            }
        };
        this.m_transactionDelegate.runInTransaction(runnable, context);
    }

    public Set<QName> getHeaders() {
        return this.m_soapHandler.getHeaders();
    }

    protected ScoutTransactionDelegate createTransactionDelegate(ScoutTransaction scoutTransaction) {
        return new ScoutTransactionDelegate(scoutTransaction);
    }

    @Override
    public Handler<T> getHandler() {
        return this.m_soapHandler;
    }
}

