/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient;
import org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler;
import org.eclipse.scout.jaxws.service.IWebServiceClient;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.ServiceRegistration;

@ScoutWebServiceClient
public class AbstractWebServiceClient<S extends Service, P>
extends AbstractService
implements IWebServiceClient {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractWebServiceClient.class);
    private WebServiceClient m_webServiceClientAnnotation;
    private String m_url;
    private URL m_wsdlLocation;
    private String m_targetNamespace;
    private String m_serviceName;
    private Integer m_requestTimeout;
    private Integer m_connectTimeout;
    private String m_username;
    private String m_password;
    private Class<? extends Service> m_serviceClazz;
    private Class<?> m_portTypeClazz;

    public void initializeService(ServiceRegistration registration) {
        this.m_serviceClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.m_portTypeClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.m_webServiceClientAnnotation = this.m_serviceClazz.getAnnotation(WebServiceClient.class);
        if (this.m_webServiceClientAnnotation == null) {
            throw new WebServiceException("Missing required annotation '" + WebServiceClient.class.getName() + "' on webservice client '" + this.getClass().getName() + "'");
        }
        this.initConfig();
        super.initializeService(registration);
    }

    protected void initConfig() {
        this.setWsdlLocation(this.getConfiguredWsdlLocation());
        this.setUrl(this.getConfiguredUrl());
        this.setTargetNamespace(this.getConfiguredTargetNamespace());
        this.setServiceName(this.getConfiguredServiceName());
        this.setUsername(this.getConfiguredUsername());
        this.setPassword(this.getConfiguredPassword());
        this.setConnectTimeout(this.getConfiguredConnectTimeout());
        this.setRequestTimeout(this.getConfiguredRequestTimeout());
    }

    public S getWebService() {
        if (this.getWsdlLocation() == null) {
            throw new WebServiceException("No location for WSDL configured on webservice proxy '" + this.getClass().getName() + "'.");
        }
        try {
            Constructor<? extends Service> constructor = this.m_serviceClazz.getConstructor(URL.class, QName.class);
            Service service = constructor.newInstance(this.getWsdlLocation(), new QName(this.getTargetNamespace(), this.getServiceName()));
            service.setHandlerResolver(new HandlerResolver(){

                public List<Handler> getHandlerChain(PortInfo portInfo) {
                    ArrayList<Handler> list = new ArrayList<Handler>();
                    IAuthenticationHandler authenticationHandler = AbstractWebServiceClient.this.createAuthenticationHandler();
                    if (authenticationHandler != null) {
                        try {
                            authenticationHandler.setUsername(AbstractWebServiceClient.this.getUsername());
                            authenticationHandler.setPassword(AbstractWebServiceClient.this.getPassword());
                            if (AbstractWebServiceClient.this.execPrepareAuthenticationHandler(authenticationHandler)) {
                                list.add((Handler)authenticationHandler);
                            }
                        }
                        catch (ProcessingException e) {
                            LOG.error("Authentication handler could not be installed.", (Throwable)e);
                        }
                    }
                    LinkedList<SOAPHandler<SOAPMessageContext>> handlers = new LinkedList<SOAPHandler<SOAPMessageContext>>();
                    AbstractWebServiceClient.this.execInstallHandlers(handlers);
                    if (handlers.size() > 0) {
                        list.addAll(handlers);
                    }
                    return list;
                }
            });
            return (S)service;
        }
        catch (Exception e) {
            throw new WebServiceException("Webservice proxy '" + this.getClass().getName() + "' could not be created.", (Throwable)e);
        }
    }

    public P getPortType() {
        return this.getPortType(this.getUrl());
    }

    public P getPortType(String url) {
        if (StringUtility.isNullOrEmpty((String)url)) {
            throw new WebServiceException("No endpoint URL configured for webservice client '" + this.getClass().getName() + "'.");
        }
        Object portType = this.getWebService().getPort(this.m_portTypeClazz);
        ((BindingProvider)portType).getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        if (NumberUtility.nvl((Integer)this.getRequestTimeout(), (Number)0) > 0) {
            ((BindingProvider)portType).getRequestContext().put("com.sun.xml.internal.ws.request.timeout", this.getRequestTimeout());
        }
        if (NumberUtility.nvl((Integer)this.getConnectTimeout(), (Number)0) > 0) {
            ((BindingProvider)portType).getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", this.getConnectTimeout());
        }
        return (P)portType;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=20.0)
    protected URL getConfiguredWsdlLocation() {
        String wsdlLocation = this.m_webServiceClientAnnotation.wsdlLocation();
        if (StringUtility.isNullOrEmpty((String)wsdlLocation)) {
            throw new WebServiceException("No WSDL file location configured on webservice proxy '" + this.getClass().getName() + "'");
        }
        IPath path = new Path("").addTrailingSeparator().append((IPath)new Path(wsdlLocation));
        URL urlWsdlLocation = this.getClass().getResource(path.toPortableString());
        if (urlWsdlLocation == null) {
            throw new WebServiceException("Could not find WSDL file '" + StringUtility.nvl((Object)wsdlLocation, (String)"?") + "' of webservice client '" + this.getClass().getName() + "'");
        }
        return urlWsdlLocation;
    }

    @ConfigProperty(value="STRING")
    @Order(value=30.0)
    protected String getConfiguredUrl() {
        return null;
    }

    @Order(value=40.0)
    protected String getConfiguredServiceName() {
        return this.m_webServiceClientAnnotation.name();
    }

    @Order(value=50.0)
    protected String getConfiguredTargetNamespace() {
        return this.m_webServiceClientAnnotation.targetNamespace();
    }

    @ConfigProperty(value="STRING")
    @Order(value=60.0)
    protected String getConfiguredUsername() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=70.0)
    protected String getConfiguredPassword() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=80.0)
    protected Integer getConfiguredConnectTimeout() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=90.0)
    protected Integer getConfiguredRequestTimeout() {
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected boolean execPrepareAuthenticationHandler(IAuthenticationHandler authenticationHandler) throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execInstallHandlers(List<SOAPHandler<SOAPMessageContext>> handlers) {
    }

    private IAuthenticationHandler createAuthenticationHandler() {
        ScoutWebServiceClient annotation = null;
        Class<?> declaringClass = this.getClass();
        while (annotation == null && declaringClass != null && declaringClass != Object.class) {
            annotation = declaringClass.getAnnotation(ScoutWebServiceClient.class);
            declaringClass = declaringClass.getSuperclass();
        }
        if (annotation == null) {
            return null;
        }
        Class<? extends IAuthenticationHandler> authenticationHandlerClazz = annotation.authenticationHandler();
        if (authenticationHandlerClazz == null || authenticationHandlerClazz == IAuthenticationHandler.NONE.class) {
            return null;
        }
        IAuthenticationHandler authenticationHandler = null;
        try {
            authenticationHandler = authenticationHandlerClazz.newInstance();
        }
        catch (Exception e) {
            LOG.error("Failed to instantiate authentication handler '" + authenticationHandlerClazz.getName() + "'.", (Throwable)e);
            return null;
        }
        return authenticationHandler;
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public String getTargetNamespace() {
        return this.m_targetNamespace;
    }

    @Override
    public String getUsername() {
        return this.m_username;
    }

    @Override
    public URL getWsdlLocation() {
        return this.m_wsdlLocation;
    }

    @Override
    public void setPassword(String password) {
        this.m_password = password;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public void setTargetNamespace(String targetNamespace) {
        this.m_targetNamespace = targetNamespace;
    }

    @Override
    public void setUsername(String username) {
        this.m_username = username;
    }

    @Override
    public Integer getRequestTimeout() {
        return this.m_requestTimeout;
    }

    @Override
    public void setRequestTimeout(Integer requestTimeout) {
        this.m_requestTimeout = requestTimeout;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.m_connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.m_connectTimeout = connectTimeout;
    }

    @Override
    public void setWsdlLocation(URL wsdlLocation) {
        this.m_wsdlLocation = wsdlLocation;
    }

    @Override
    public String getUrl() {
        return this.m_url;
    }

    @Override
    public void setUrl(String url) {
        this.m_url = url;
    }
}

