/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.desktop;

import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;

public class ActiveOutlineObserver {
    private IOutline m_activeOutline;
    private IDesktop m_desktop;
    private P_DesktopListener m_desktopListener;
    private Set<TreeListener> m_outlineTreeListeners;
    private Set<TreeListener> m_outlineUITreeListeners;
    private Set<PropertyChangeListener> m_outlinePropertyChangeListeners;

    public ActiveOutlineObserver() {
        this(null);
    }

    public ActiveOutlineObserver(IDesktop desktop) {
        if (desktop == null) {
            desktop = ClientSyncJob.getCurrentSession().getDesktop();
        }
        this.m_desktop = desktop;
        if (this.m_desktop == null) {
            throw new IllegalArgumentException("No desktop found. Cannot create ActiveOutlineObserver.");
        }
        this.m_activeOutline = desktop.getOutline();
        this.m_outlineTreeListeners = new HashSet<TreeListener>();
        this.m_outlineUITreeListeners = new HashSet<TreeListener>();
        this.m_outlinePropertyChangeListeners = new HashSet<PropertyChangeListener>();
        this.m_desktopListener = new P_DesktopListener();
        desktop.addDesktopListener((DesktopListener)this.m_desktopListener);
    }

    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    public IOutline getActiveOutline() {
        return this.m_activeOutline;
    }

    private void destroy() {
        if (this.m_desktopListener != null) {
            this.getDesktop().removeDesktopListener((DesktopListener)this.m_desktopListener);
            this.m_desktopListener = null;
        }
        this.removeAllListeners(this.m_activeOutline);
        this.m_outlineTreeListeners.clear();
        this.m_outlineUITreeListeners.clear();
        this.m_outlinePropertyChangeListeners.clear();
    }

    public void addOutlineTreeListener(TreeListener treeListener) {
        if (treeListener == null) {
            return;
        }
        if (this.m_activeOutline != null) {
            this.m_activeOutline.addTreeListener(treeListener);
        }
        this.m_outlineTreeListeners.add(treeListener);
    }

    public void addOutlineUITreeListener(TreeListener treeListener) {
        if (treeListener == null) {
            return;
        }
        if (this.m_activeOutline != null) {
            this.m_activeOutline.addTreeListener(treeListener);
        }
        this.m_outlineUITreeListeners.add(treeListener);
    }

    public void addOutlinePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_activeOutline != null) {
            this.m_activeOutline.addPropertyChangeListener(propertyChangeListener);
        }
        this.m_outlinePropertyChangeListeners.add(propertyChangeListener);
    }

    public void removeOutlineTreeListener(TreeListener treeListener) {
        if (treeListener == null) {
            return;
        }
        if (this.m_activeOutline != null) {
            this.m_activeOutline.removeTreeListener(treeListener);
        }
        this.m_outlineTreeListeners.remove(treeListener);
    }

    public void removeOutlineUITreeListener(TreeListener treeListener) {
        if (treeListener == null) {
            return;
        }
        if (this.m_activeOutline != null) {
            this.m_activeOutline.removeTreeListener(treeListener);
        }
        this.m_outlineUITreeListeners.remove(treeListener);
    }

    public void removeOutlinePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.m_activeOutline != null) {
            this.m_activeOutline.removePropertyChangeListener(propertyChangeListener);
        }
        this.m_outlinePropertyChangeListeners.remove(propertyChangeListener);
    }

    private void removeAllListeners(IOutline outline) {
        if (outline == null) {
            return;
        }
        for (TreeListener treeListener : this.m_outlineTreeListeners) {
            outline.removeTreeListener(treeListener);
        }
        for (TreeListener treeListener : this.m_outlineUITreeListeners) {
            outline.removeTreeListener(treeListener);
        }
        for (PropertyChangeListener propertyChangeListener : this.m_outlinePropertyChangeListeners) {
            outline.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void addAllListeners(IOutline outline) {
        if (outline == null) {
            return;
        }
        for (TreeListener treeListener : this.m_outlineTreeListeners) {
            outline.addTreeListener(treeListener);
        }
        for (TreeListener treeListener : this.m_outlineUITreeListeners) {
            outline.addUITreeListener(treeListener);
        }
        for (PropertyChangeListener propertyChangeListener : this.m_outlinePropertyChangeListeners) {
            outline.addPropertyChangeListener(propertyChangeListener);
        }
    }

    private class P_DesktopListener
    implements DesktopListener {
        private P_DesktopListener() {
        }

        public void desktopChanged(DesktopEvent e) {
            switch (e.getType()) {
                case 100: {
                    ActiveOutlineObserver.this.destroy();
                    break;
                }
                case 200: {
                    this.handleOutlineChanged(e);
                    break;
                }
            }
        }

        private void handleOutlineChanged(DesktopEvent e) {
            IOutline outline = e.getOutline();
            if (ActiveOutlineObserver.this.m_activeOutline != null) {
                ActiveOutlineObserver.this.removeAllListeners(ActiveOutlineObserver.this.m_activeOutline);
            }
            if (outline != null) {
                ActiveOutlineObserver.this.addAllListeners(outline);
            }
            ActiveOutlineObserver.this.m_activeOutline = outline;
        }
    }
}

