/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.outline;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.IPageForm;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.IForm;

public class PageFormMap {
    private Map<String, List<IPageForm>> m_pageFormMaps = new HashMap<String, List<IPageForm>>();

    public IPageForm get(IPage page) {
        return this.get(page, false);
    }

    public IPageForm get(IPage page, boolean onlyVisible) {
        if (page == null) {
            return null;
        }
        for (List<IPageForm> pageFormList : this.m_pageFormMaps.values()) {
            if (pageFormList == null) continue;
            for (IPageForm pageForm : pageFormList) {
                if (!page.equals(pageForm.getPage())) continue;
                IDesktop desktop = ClientJob.getCurrentSession().getDesktop();
                if (onlyVisible && !desktop.isShowing((IForm)pageForm)) continue;
                return pageForm;
            }
        }
        return null;
    }

    public IPageForm get(String displayViewId, IPage page) {
        if (displayViewId == null || page == null) {
            return null;
        }
        List<IPageForm> list = this.m_pageFormMaps.get(displayViewId);
        if (list == null) {
            return null;
        }
        for (IPageForm pageForm : list) {
            if (!displayViewId.equals(pageForm.getDisplayViewId()) || !page.equals(pageForm.getPage())) continue;
            return pageForm;
        }
        return null;
    }

    public void put(IPageForm pageForm) {
        String displayViewId = pageForm.getDisplayViewId();
        List<IPageForm> list = this.m_pageFormMaps.get(displayViewId);
        if (list == null) {
            list = new LinkedList<IPageForm>();
        }
        list.add(pageForm);
        this.m_pageFormMaps.put(displayViewId, list);
    }

    public void remove(IPage page) {
        for (List<IPageForm> pageFormList : this.m_pageFormMaps.values()) {
            if (pageFormList == null) continue;
            for (IPageForm pageForm : new LinkedList<IPageForm>(pageFormList)) {
                if (!page.equals(pageForm.getPage())) continue;
                pageFormList.remove(pageForm);
            }
        }
    }

    public void remove(IPageForm pageForm) {
        for (List<IPageForm> pageFormList : this.m_pageFormMaps.values()) {
            if (pageFormList == null) continue;
            pageFormList.remove(pageForm);
        }
    }

    public void clear() {
        this.m_pageFormMaps.clear();
    }
}

