/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.session;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.shared.services.common.session.IJobRunnable;
import org.eclipse.scout.rt.shared.services.common.session.ISessionService;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-1.0f)
public class DefaultClientSessionService
extends AbstractService
implements ISessionService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultClientSessionService.class);

    public IClientSession getCurrentSession() {
        return ClientJob.getCurrentSession();
    }

    public JobEx createAsyncJob(IJobRunnable runnable) {
        return this.createAsyncJob(null, runnable);
    }

    public JobEx createAsyncJob(String name, IJobRunnable runnable) {
        IClientSession session = this.getCurrentSession();
        if (session == null) {
            LOG.error("client session not available");
            return null;
        }
        if (name == null) {
            name = "client session async job";
        }
        return new P_ClientSessionAsyncJob(name, session, true, runnable);
    }

    private static class P_ClientSessionAsyncJob
    extends ClientAsyncJob {
        private final IJobRunnable m_runnable;

        public P_ClientSessionAsyncJob(String name, IClientSession session, boolean system, IJobRunnable runnable) {
            super(name, session, system);
            this.m_runnable = runnable;
        }

        @Override
        protected IStatus runStatus(IProgressMonitor monitor) {
            return this.m_runnable.run(monitor);
        }
    }
}

