/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.servicetunnel.http.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.perf.IPerformanceAnalyzerService;
import org.eclipse.scout.rt.shared.services.common.ping.IPingService;
import org.eclipse.scout.service.SERVICES;

public class ClientNotificationPollingJob
extends ClientAsyncJob {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientNotificationPollingJob.class);
    private long m_pollInterval;
    private boolean m_analyzeNetworkLatency;

    public ClientNotificationPollingJob(IClientSession session, long pollInterval, boolean analyzeNetworkLatency) {
        super("Client notification fetcher", session, true);
        this.updatePollingValues(pollInterval, analyzeNetworkLatency);
    }

    public void updatePollingValues(long pollInterval, boolean analyzeNetworkLatency) {
        this.m_pollInterval = Math.max(1000L, pollInterval);
        this.m_analyzeNetworkLatency = analyzeNetworkLatency;
    }

    @Override
    protected IStatus runStatus(IProgressMonitor monitor) {
        block4: {
            IPingService pingService = (IPingService)SERVICES.getService(IPingService.class);
            try {
                pingService.ping("GetClientNotifications");
            }
            catch (Throwable t) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info("polling", t);
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        long netLatency = 0L;
        IPerformanceAnalyzerService perf = (IPerformanceAnalyzerService)SERVICES.getService(IPerformanceAnalyzerService.class);
        if (perf != null) {
            netLatency = perf.getNetworkLatency();
        }
        long sleepInterval = this.m_analyzeNetworkLatency ? Math.max(this.m_pollInterval, 10L * netLatency) : this.m_pollInterval;
        this.schedule(sleepInterval);
        return Status.OK_STATUS;
    }
}

