/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.ValueFieldMenuType;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;

public final class ActionUtility {
    public static IActionFilter FALSE_FILTER = new IActionFilter(){

        @Override
        public boolean accept(IAction action) {
            return false;
        }
    };
    public static IActionFilter TRUE_FILTER = new IActionFilter(){

        @Override
        public boolean accept(IAction action) {
            return true;
        }
    };

    public static <T extends IAction> List<T> visibleNormalizedActions(List<T> actionNodes) {
        return ActionUtility.visibleNormalizedActions(actionNodes, ActionUtility.createVisibleFilter());
    }

    public static <T extends IAction> List<T> visibleNormalizedActions(List<T> actionNodes, IActionFilter filter) {
        if (actionNodes == null) {
            return CollectionUtility.emptyArrayList();
        }
        List<T> cleanedActions = ActionUtility.getActions(actionNodes, filter);
        ActionUtility.normalizeSeparators(cleanedActions);
        return cleanedActions;
    }

    public static <T extends IAction> void normalizeSeparators(List<T> actions) {
        IAction prevSeparator = null;
        IAction prevAction = null;
        ListIterator<T> it = actions.listIterator();
        while (it.hasNext()) {
            IAction actionNode = (IAction)it.next();
            if (actionNode.isSeparator()) {
                if (prevAction == null || prevSeparator != null) {
                    it.remove();
                }
                prevAction = null;
                prevSeparator = actionNode;
                continue;
            }
            prevSeparator = null;
            prevAction = actionNode;
        }
        while (it.hasPrevious()) {
            IAction previous = (IAction)it.previous();
            if (!previous.isSeparator()) break;
            it.remove();
        }
    }

    public static <T extends IAction> List<T> getActions(List<T> actions, final IActionFilter filter) {
        if (actions != null) {
            ArrayList<IAction> result = new ArrayList<IAction>(actions.size());
            for (IAction a : actions) {
                if (a instanceof IActionNode) {
                    final BooleanHolder visibleHolder = new BooleanHolder(Boolean.valueOf(false));
                    a.acceptVisitor(new IActionVisitor(){

                        @Override
                        public int visit(IAction action) {
                            if (action instanceof IActionNode && ((IActionNode)action).hasChildActions()) {
                                return 1;
                            }
                            if (action.isSeparator()) {
                                return 1;
                            }
                            if (filter.accept(action)) {
                                visibleHolder.setValue((Object)true);
                                return 0;
                            }
                            return 1;
                        }
                    });
                    if (!a.isSeparator() && !((Boolean)visibleHolder.getValue()).booleanValue()) continue;
                    result.add(a);
                    continue;
                }
                if (a.isSeparator()) {
                    result.add(a);
                    continue;
                }
                if (!filter.accept(a)) continue;
                result.add(a);
            }
            return result;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static void initActions(List<? extends IAction> actions) throws ProcessingException {
        InitActionVisitor v = new InitActionVisitor();
        for (IAction iAction : actions) {
            iAction.acceptVisitor(v);
        }
        v.handleResult();
    }

    /*
     * WARNING - void declaration
     */
    public static IActionFilter createMenuFilterVisibleForTableSelection(List<? extends ITableRow> selection) {
        boolean allEnabled = true;
        if (!CollectionUtility.isEmpty(selection)) {
            allEnabled = true;
            for (ITableRow iTableRow : selection) {
                if (iTableRow.isEnabled()) continue;
                allEnabled = false;
                break;
            }
        }
        if (allEnabled) {
            void var2_7;
            if (CollectionUtility.isEmpty(selection)) {
                TableMenuType tableMenuType = TableMenuType.EmptySpace;
            } else if (CollectionUtility.size(selection) == 1) {
                TableMenuType tableMenuType = TableMenuType.SingleSelection;
            } else {
                TableMenuType tableMenuType = TableMenuType.MultiSelection;
            }
            return ActionUtility.createMenuFilterVisibleAndMenuTypes(CollectionUtility.hashSet((Object)var2_7));
        }
        return FALSE_FILTER;
    }

    public static IActionFilter createMenuFilterVisibleForValueFieldValue(Object value) {
        ValueFieldMenuType menuType = value == null ? ValueFieldMenuType.Null : ValueFieldMenuType.NotNull;
        return ActionUtility.createMenuFilterVisibleAndMenuTypes(menuType);
    }

    public static IActionFilter createVisibleFilter() {
        return new IActionFilter(){

            @Override
            public boolean accept(IAction action) {
                return action.isVisible();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static IActionFilter createMenuFilterVisibleForTreeSelection(Set<? extends ITreeNode> selection) {
        boolean allEnabled = true;
        if (!CollectionUtility.isEmpty(selection)) {
            allEnabled = true;
            for (ITreeNode iTreeNode : selection) {
                if (iTreeNode.isEnabled()) continue;
                allEnabled = false;
                break;
            }
        }
        if (allEnabled) {
            void var2_7;
            if (CollectionUtility.isEmpty(selection)) {
                TreeMenuType treeMenuType = TreeMenuType.EmptySpace;
            } else if (CollectionUtility.size(selection) == 1) {
                TreeMenuType treeMenuType = TreeMenuType.SingleSelection;
            } else {
                TreeMenuType treeMenuType = TreeMenuType.MultiSelection;
            }
            return ActionUtility.createMenuFilterVisibleAndMenuTypes(CollectionUtility.hashSet((Object)var2_7));
        }
        return FALSE_FILTER;
    }

    public static IActionFilter createMenuFilterVisibleAndMenuTypes(IMenuType ... menuTypes) {
        return ActionUtility.createMenuFilterVisibleAndMenuTypes(CollectionUtility.hashSet((Object[])menuTypes));
    }

    public static IActionFilter createMenuFilterVisibleAndMenuTypes(final Set<? extends IMenuType> menuTypes) {
        return new IActionFilter(){

            @Override
            public boolean accept(IAction action) {
                if (action.isVisible() && action instanceof IMenu) {
                    IMenu menu = (IMenu)action;
                    for (IMenuType t : menuTypes) {
                        if (!menu.getMenuTypes().contains(t)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static IActionFilter createMenuFilterMenuTypes(IMenuType ... menuTypes) {
        return ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object[])menuTypes));
    }

    public static IActionFilter createMenuFilterMenuTypes(final Set<? extends IMenuType> menuTypes) {
        return new IActionFilter(){

            @Override
            public boolean accept(IAction action) {
                if (action instanceof IMenu) {
                    IMenu menu = (IMenu)action;
                    for (IMenuType t : menuTypes) {
                        if (!menu.getMenuTypes().contains(t)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private static class InitActionVisitor
    implements IActionVisitor {
        private ProcessingException m_firstEx;

        private InitActionVisitor() {
        }

        @Override
        public int visit(IAction action) {
            block4: {
                try {
                    action.initAction();
                }
                catch (ProcessingException e) {
                    if (this.m_firstEx == null) {
                        this.m_firstEx = e;
                    }
                }
                catch (Throwable t) {
                    if (this.m_firstEx != null) break block4;
                    this.m_firstEx = new ProcessingException("Unexpected", t);
                }
            }
            return 1;
        }

        public void handleResult() throws ProcessingException {
            if (this.m_firstEx != null) {
                throw this.m_firstEx;
            }
        }
    }
}

