/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.ValueFieldMenuType;
import org.eclipse.scout.rt.client.ui.action.tree.AbstractActionNode;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;

public abstract class AbstractMenu
extends AbstractActionNode<IMenu>
implements IMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractMenu.class);
    private boolean m_singleSelectionAction;
    private boolean m_multiSelectionAction;
    private boolean m_emptySpaceAction;
    private boolean m_visibleProperty;
    private Object m_ownerValue;

    public AbstractMenu() {
        this(true);
    }

    public AbstractMenu(boolean callInitializer) {
        super(callInitializer);
    }

    @Order(value=55.0)
    @ConfigProperty(value="MENU_TYPE")
    protected Set<? extends IMenuType> getConfiguredMenuTypes() {
        return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.SingleSelection, TreeMenuType.SingleSelection, ValueFieldMenuType.NotNull});
    }

    @Deprecated
    @Order(value=60.0)
    protected boolean getConfiguredSingleSelectionAction() {
        return true;
    }

    @Deprecated
    @Order(value=70.0)
    protected boolean getConfiguredMultiSelectionAction() {
        return false;
    }

    @Deprecated
    @Order(value=90.0)
    protected boolean getConfiguredEmptySpaceAction() {
        return false;
    }

    @Override
    public final void handleOwnerValueChanged(Object newValue) throws ProcessingException {
        if (!CompareUtility.equals((Object)this.m_ownerValue, (Object)newValue)) {
            this.m_ownerValue = newValue;
            this.execOwnerValueChanged(newValue);
        }
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execOwnerValueChanged(Object newOwnerValue) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execAboutToShow() throws ProcessingException {
    }

    @Override
    public final void aboutToShow() {
        try {
            this.aboutToShowInternal();
            this.execAboutToShow();
            for (IMenu m : this.getChildActions()) {
                m.aboutToShow();
            }
        }
        catch (Throwable t) {
            LOG.warn("Action " + this.getClass().getName(), t);
        }
    }

    protected void aboutToShowInternal() {
    }

    protected Collection<ITableRow> convertToTableRows(Collection<?> input) {
        if (input == null) {
            return null;
        }
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>(input.size());
        for (Object o : input) {
            if (!(o instanceof ITableRow)) continue;
            rows.add((ITableRow)o);
        }
        if (rows.size() == input.size()) {
            return rows;
        }
        return null;
    }

    protected Collection<ITreeNode> convertToTreeNodes(Collection<?> input) {
        if (input == null) {
            return null;
        }
        ArrayList<ITreeNode> rows = new ArrayList<ITreeNode>(input.size());
        for (Object o : input) {
            if (!(o instanceof ITreeNode)) continue;
            rows.add((ITreeNode)o);
        }
        if (rows.size() == input.size()) {
            return rows;
        }
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setEmptySpaceAction(this.getConfiguredEmptySpaceAction());
        this.setSingleSelectionAction(this.getConfiguredSingleSelectionAction());
        this.setMultiSelectionAction(this.getConfiguredMultiSelectionAction());
        if (!(this.isSingleSelectionAction() || this.isMultiSelectionAction() || this.isEmptySpaceAction())) {
            this.setEmptySpaceAction(true);
        }
        if (!ConfigurationUtility.isMethodOverwrite(AbstractMenu.class, (String)"getConfiguredMenuTypes", (Class[])new Class[0], this.getClass())) {
            HashSet<Enum> menuTypes = new HashSet<Enum>();
            if (this.isSingleSelectionAction()) {
                menuTypes.add(TableMenuType.SingleSelection);
                menuTypes.add(TreeMenuType.SingleSelection);
                menuTypes.add(ValueFieldMenuType.NotNull);
            }
            if (this.isMultiSelectionAction()) {
                menuTypes.add(TableMenuType.MultiSelection);
                menuTypes.add(TreeMenuType.MultiSelection);
                menuTypes.add(ValueFieldMenuType.NotNull);
            }
            if (this.isEmptySpaceAction()) {
                menuTypes.add(TableMenuType.EmptySpace);
                menuTypes.add(TreeMenuType.EmptySpace);
                menuTypes.add(ValueFieldMenuType.Null);
            }
            this.setMenuTypes(menuTypes);
        } else {
            this.setMenuTypes(this.getConfiguredMenuTypes());
        }
    }

    @Override
    public void addChildActions(List<? extends IMenu> actionList) {
        super.addChildActions(actionList);
        if (CollectionUtility.hasElements(actionList)) {
            this.afterChildMenusAdd(actionList);
        }
    }

    @Override
    public void removeChildActions(List<? extends IMenu> actionList) {
        super.removeChildActions(actionList);
        if (CollectionUtility.hasElements(actionList)) {
            this.afterChildMenusRemove(actionList);
        }
    }

    protected void afterChildMenusAdd(List<? extends IMenu> newChildMenus) {
        if (CollectionUtility.hasElements(newChildMenus)) {
            final Object ownerValue = this.m_ownerValue;
            IActionVisitor visitor = new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        try {
                            menu.handleOwnerValueChanged(ownerValue);
                        }
                        catch (ProcessingException e) {
                            LOG.error("error during handle owner value changed.", (Throwable)e);
                        }
                    }
                    return 1;
                }
            };
            for (IMenu iMenu : newChildMenus) {
                iMenu.acceptVisitor(visitor);
            }
        }
    }

    protected void afterChildMenusRemove(List<? extends IMenu> childMenusToRemove) {
        if (CollectionUtility.hasElements(childMenusToRemove)) {
            IActionVisitor visitor = new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        try {
                            menu.handleOwnerValueChanged(null);
                        }
                        catch (ProcessingException e) {
                            LOG.error("error during handle owner value changed.", (Throwable)e);
                        }
                    }
                    return 1;
                }
            };
            for (IMenu iMenu : childMenusToRemove) {
                iMenu.acceptVisitor(visitor);
            }
        }
    }

    @Override
    public Set<IMenuType> getMenuTypes() {
        return CollectionUtility.hashSet((Collection)((Set)this.propertySupport.getProperty("propMenuTypes")));
    }

    public void setMenuTypes(Set<? extends IMenuType> menuTypes) {
        this.propertySupport.setProperty("propMenuTypes", (Object)CollectionUtility.hashSet(menuTypes));
    }

    @Override
    @Deprecated
    public boolean isSingleSelectionAction() {
        return this.m_singleSelectionAction;
    }

    @Override
    @Deprecated
    public void setSingleSelectionAction(boolean b) {
        this.m_singleSelectionAction = b;
    }

    @Override
    @Deprecated
    public boolean isMultiSelectionAction() {
        return this.m_multiSelectionAction;
    }

    @Override
    @Deprecated
    public void setMultiSelectionAction(boolean b) {
        this.m_multiSelectionAction = b;
    }

    @Override
    @Deprecated
    public boolean isEmptySpaceAction() {
        return this.m_emptySpaceAction;
    }

    @Override
    @Deprecated
    public void setEmptySpaceAction(boolean b) {
        this.m_emptySpaceAction = b;
    }
}

