/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;

public final class MenuUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MenuUtility.class);

    private MenuUtility() {
    }

    public static List<IKeyStroke> getKeyStrokesFromMenus(List<? extends IMenu> menu) {
        HashSet<String> keys = new HashSet<String>();
        if (menu != null) {
            ArrayList<IKeyStroke> keyStrokes = new ArrayList<IKeyStroke>(menu.size());
            for (IMenu iMenu : menu) {
                String s = iMenu.getKeyStroke();
                if (!StringUtility.hasText((String)s)) continue;
                try {
                    KeyStroke ks = new KeyStroke(s, iMenu);
                    ks.initAction();
                    if (!keys.add(ks.getKeyStroke())) continue;
                    keyStrokes.add(ks);
                }
                catch (ProcessingException e) {
                    LOG.error("could not initialize enter key stroke.", (Throwable)e);
                }
            }
            return keyStrokes;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static <T extends IActionNode<?>> boolean isVisible(T menu) {
        if (!menu.isVisible()) {
            return false;
        }
        if (menu.hasChildActions()) {
            boolean visible = false;
            for (Object o : menu.getChildActions()) {
                IActionNode m;
                if (!(o instanceof IActionNode) || (m = (IActionNode)o).isSeparator() || !m.isVisible()) continue;
                visible = true;
                break;
            }
            return visible;
        }
        return true;
    }

    public static <T extends IActionNode<?>> List<T> consolidateMenus(List<T> original) {
        LinkedList<IActionNode> consolidatedMenus = new LinkedList<IActionNode>();
        IAction lastMenu = null;
        for (IActionNode m : original) {
            if (!MenuUtility.isVisible(m)) continue;
            if (m.isSeparator()) {
                if (lastMenu != null && !lastMenu.isSeparator()) {
                    consolidatedMenus.add(m);
                }
            } else {
                consolidatedMenus.add(m);
            }
            lastMenu = m;
        }
        while (!consolidatedMenus.isEmpty() && ((IActionNode)consolidatedMenus.getLast()).isSeparator()) {
            consolidatedMenus.removeLast();
        }
        return consolidatedMenus;
    }
}

