/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractPropertyObserverContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IFormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class FormFieldContextMenu<T extends IFormField>
extends AbstractPropertyObserverContextMenu<T>
implements IFormFieldContextMenu {
    public FormFieldContextMenu(T owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.handleOwnerEnabledChanged();
    }

    @Override
    protected void afterChildMenusAdd(List<? extends IMenu> newChildMenus) {
        super.afterChildMenusAdd(newChildMenus);
        this.handleOwnerEnabledChanged();
    }

    @Override
    protected void afterChildMenusRemove(List<? extends IMenu> childMenusToRemove) {
        super.afterChildMenusRemove(childMenusToRemove);
        this.handleOwnerEnabledChanged();
    }

    protected void handleOwnerEnabledChanged() {
        if (this.getOwner() != null) {
            final boolean enabled = ((IFormField)this.getOwner()).isEnabled();
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    IMenu menu;
                    if (action instanceof IMenu && !(menu = (IMenu)action).hasChildActions() && menu.isInheritAccessibility()) {
                        menu.setEnabled(enabled);
                    }
                    return 1;
                }
            });
        }
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        super.handleOwnerPropertyChanged(evt);
        if ("enabled".equals(evt.getPropertyName())) {
            this.handleOwnerEnabledChanged();
        }
    }
}

