/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractPropertyObserverContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITreeContextMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class TreeContextMenu
extends AbstractPropertyObserverContextMenu<ITree>
implements ITreeContextMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TreeContextMenu.class);

    public TreeContextMenu(ITree owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ((ITree)this.getOwner()).addTreeListener(new P_OwnerTreeListener());
        this.setActiveFilter(ActionUtility.createMenuFilterVisibleForTreeSelection(((ITree)this.getOwner()).getSelectedNodes()));
        this.calculateLocalVisibility();
    }

    @Override
    protected void afterChildMenusAdd(List<? extends IMenu> newChildMenus) {
        super.afterChildMenusAdd(newChildMenus);
        this.handleOwnerEnabledChanged();
    }

    @Override
    protected void afterChildMenusRemove(List<? extends IMenu> childMenusToRemove) {
        super.afterChildMenusRemove(childMenusToRemove);
        this.handleOwnerEnabledChanged();
    }

    protected void handleOwnerEnabledChanged() {
        if (this.getOwner() != null) {
            final boolean enabled = ((ITree)this.getOwner()).isEnabled();
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    IMenu menu;
                    if (action instanceof IMenu && !(menu = (IMenu)action).hasChildActions() && menu.isInheritAccessibility()) {
                        menu.setEnabled(enabled);
                    }
                    return 1;
                }
            });
        }
    }

    protected void handleOwnerValueChanged() {
        if (this.getOwner() != null) {
            final Set<ITreeNode> ownerSelection = ((ITree)this.getOwner()).getSelectedNodes();
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        try {
                            menu.handleOwnerValueChanged(ownerSelection);
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                    }
                    return 1;
                }
            });
            this.setActiveFilter(ActionUtility.createMenuFilterVisibleForTreeSelection(ownerSelection));
            this.calculateLocalVisibility();
        }
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            this.handleOwnerEnabledChanged();
        }
    }

    private class P_OwnerTreeListener
    extends TreeAdapter {
        private P_OwnerTreeListener() {
        }

        @Override
        public void treeChanged(TreeEvent e) {
            if (e.getType() == 40) {
                TreeContextMenu.this.handleOwnerValueChanged();
            }
        }
    }
}

