/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractActionNode<T extends IActionNode>
extends AbstractAction
implements IActionNode<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractActionNode.class);
    private T m_parent;

    public AbstractActionNode() {
    }

    public AbstractActionNode(boolean callInitializer) {
        super(callInitializer);
    }

    private List<? extends Class<? extends IActionNode>> getConfiguredChildActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IActionNode.class);
        List foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IActionNode.class);
        return ConfigurationUtility.removeReplacedClasses((List)foca);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ArrayList<IActionNode> nodeList = new ArrayList<IActionNode>();
        List<Class<IActionNode>> ma = this.getConfiguredChildActions();
        for (Class<IActionNode> a : ma) {
            try {
                IActionNode node = (IActionNode)ConfigurationUtility.newInnerInstance((Object)this, a);
                node.setParent(this);
                nodeList.add(node);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + a.getName() + "'.", (Throwable)e));
            }
        }
        try {
            this.injectActionNodesInternal(nodeList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contribute action nodes.", (Throwable)e);
        }
        this.setChildActions(nodeList);
    }

    protected void injectActionNodesInternal(List<T> nodeList) {
    }

    @Override
    public void setContainerInternal(ITypeWithClassId container) {
        super.setContainerInternal(container);
        this.setContainerOnActions(this.getChildActionsInternal());
    }

    protected void setContainerOnActions(List<? extends T> actions) {
        if (actions != null) {
            for (IActionNode childAction : actions) {
                if (childAction == null) continue;
                childAction.setContainerInternal(this.getContainer());
            }
        }
    }

    @Override
    public T getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(T parent) {
        this.m_parent = parent;
    }

    @Override
    protected void prepareActionInternal() throws ProcessingException {
        super.prepareActionInternal();
        if (this.hasChildActions()) {
            for (IActionNode node : this.getChildActionsInternal()) {
                node.prepareAction();
            }
        }
    }

    private List<T> getChildActionsInternal() {
        return this.propertySupport.getPropertyList("childActions");
    }

    @Override
    public boolean hasChildActions() {
        return CollectionUtility.hasElements(this.getChildActionsInternal());
    }

    @Override
    public int getChildActionCount() {
        return CollectionUtility.size(this.getChildActionsInternal());
    }

    @Override
    public List<T> getChildActions() {
        return CollectionUtility.arrayList(this.getChildActionsInternal());
    }

    @Override
    public void setChildActions(List<? extends T> newList) {
        this.removeChildActions(this.getChildActionsInternal());
        this.addChildActions(newList);
    }

    @Override
    public void addChildAction(T action) {
        this.addChildActions(CollectionUtility.arrayList(action));
    }

    @Override
    public void addChildActions(List<? extends T> actionList) {
        ArrayList normalizedList = CollectionUtility.arrayListWithoutNullElements(actionList);
        if (!normalizedList.isEmpty()) {
            this.setContainerOnActions(normalizedList);
            List<T> childList = this.getChildActionsInternal();
            if (childList == null) {
                childList = new ArrayList<T>(normalizedList.size());
            }
            childList.addAll(normalizedList);
            this.propertySupport.setPropertyAlwaysFire("childActions", childList);
        }
    }

    @Override
    public void removeChildAction(T action) {
        this.removeChildActions(CollectionUtility.arrayList(action));
    }

    @Override
    public void removeChildActions(List<? extends T> actionList) {
        ArrayList normalizedList = CollectionUtility.arrayListWithoutNullElements(actionList);
        if (!normalizedList.isEmpty()) {
            List<T> childList = this.getChildActionsInternal();
            boolean listChanged = false;
            for (IActionNode a : normalizedList) {
                if (!childList.remove(a)) continue;
                listChanged = true;
                a.setContainerInternal(null);
            }
            if (listChanged) {
                this.propertySupport.setPropertyAlwaysFire("childActions", childList);
            }
        }
    }

    @Override
    public int acceptVisitor(IActionVisitor visitor) {
        switch (visitor.visit(this)) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                this.visitChildren(visitor);
                return 0;
            }
        }
        return this.visitChildren(visitor);
    }

    private int visitChildren(IActionVisitor visitor) {
        for (IAction t : this.getChildActions()) {
            switch (t.acceptVisitor(visitor)) {
                case 0: {
                    return 0;
                }
            }
        }
        return 1;
    }
}

