/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.internal;

import java.beans.PropertyChangeListener;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionUIFacade;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;

public class TablePageTreeMenuWrapper
implements IMenu {
    private IMenu m_wrappedMenu;
    private IPropertyObserver m_menuOwner;
    private List<IMenu> m_childMenus;
    private boolean m_localEnabled = true;
    private Set<IMenuType> m_menuTypes;

    public TablePageTreeMenuWrapper(IMenu wrappedMenu, IMenuType firstMenuType, IMenuType ... additionalTypes) {
        HashSet menuTypeSet = CollectionUtility.hashSet((Object)firstMenuType);
        if (additionalTypes != null) {
            IMenuType[] iMenuTypeArray = additionalTypes;
            int n = additionalTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IMenuType t = iMenuTypeArray[n2];
                if (t != null) {
                    menuTypeSet.add(t);
                }
                ++n2;
            }
        }
        this.m_wrappedMenu = wrappedMenu;
        this.m_menuTypes = menuTypeSet;
        this.setup();
    }

    public TablePageTreeMenuWrapper(IMenu wrappedMenu, Set<? extends IMenuType> menuTypes) {
        this.m_wrappedMenu = wrappedMenu;
        this.m_menuTypes = CollectionUtility.hashSet(menuTypes);
        this.setup();
    }

    protected void setup() {
        List childActions = this.m_wrappedMenu.getChildActions();
        ArrayList<IMenu> wrappedChildActions = new ArrayList<IMenu>(childActions.size());
        for (IMenu m : childActions) {
            wrappedChildActions.add(new TablePageTreeMenuWrapper(m, this.getMenuTypes()));
        }
        this.m_childMenus = wrappedChildActions;
    }

    public IMenu getWrappedMenu() {
        return this.m_wrappedMenu;
    }

    @Override
    public boolean isSingleSelectionAction() {
        return this.m_wrappedMenu.isSingleSelectionAction();
    }

    @Override
    public void setSingleSelectionAction(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isMultiSelectionAction() {
        return this.m_wrappedMenu.isMultiSelectionAction();
    }

    @Override
    public void setMultiSelectionAction(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isEmptySpaceAction() {
        return this.m_wrappedMenu.isEmptySpaceAction();
    }

    @Override
    public void setEmptySpaceAction(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public void handleOwnerValueChanged(Object newValue) throws ProcessingException {
    }

    @Override
    public void aboutToShow() {
        this.m_wrappedMenu.aboutToShow();
    }

    @Override
    public IMenu getParent() {
        return (IMenu)this.m_wrappedMenu.getParent();
    }

    @Override
    public void setParent(IMenu parent) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean hasChildActions() {
        return this.m_childMenus.size() > 0;
    }

    @Override
    public int getChildActionCount() {
        return this.m_childMenus.size();
    }

    @Override
    public List<IMenu> getChildActions() {
        return this.m_childMenus;
    }

    @Override
    public void setChildActions(List<? extends IMenu> actionList) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public void addChildAction(IMenu action) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public void addChildActions(List<? extends IMenu> actionList) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public void removeChildAction(IMenu action) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public void removeChildActions(List<? extends IMenu> actionList) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public void initAction() throws ProcessingException {
        this.m_wrappedMenu.initAction();
    }

    @Override
    public void doAction() throws ProcessingException {
        this.m_wrappedMenu.doAction();
    }

    @Override
    public Object getProperty(String name) {
        return this.m_wrappedMenu.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.m_wrappedMenu.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.m_wrappedMenu.hasProperty(name);
    }

    @Override
    public String getActionId() {
        return this.m_wrappedMenu.getActionId();
    }

    @Override
    public String getIconId() {
        return this.m_wrappedMenu.getIconId();
    }

    @Override
    public void setIconId(String iconId) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public String getText() {
        return this.m_wrappedMenu.getText();
    }

    @Override
    public void setText(String text) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public String getTextWithMnemonic() {
        return this.m_wrappedMenu.getTextWithMnemonic();
    }

    @Override
    public String getKeyStroke() {
        return this.m_wrappedMenu.getKeyStroke();
    }

    @Override
    public void setKeyStroke(String text) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public String getTooltipText() {
        return this.m_wrappedMenu.getTooltipText();
    }

    @Override
    public void setTooltipText(String text) {
        this.m_wrappedMenu.setTooltipText(text);
    }

    @Override
    public boolean isSeparator() {
        return this.m_wrappedMenu.isSeparator();
    }

    @Override
    public void setSeparator(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isSelected() {
        return this.m_wrappedMenu.isSelected();
    }

    @Override
    public void setSelected(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isEnabled() {
        return this.m_localEnabled && this.m_wrappedMenu.isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_localEnabled = b;
    }

    @Override
    public boolean isVisible() {
        return this.m_wrappedMenu.isVisible();
    }

    @Override
    public void setVisible(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isInheritAccessibility() {
        return this.m_wrappedMenu.isInheritAccessibility();
    }

    @Override
    public void setInheritAccessibility(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public void setEnabledPermission(Permission p) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_wrappedMenu.isEnabledGranted();
    }

    @Override
    public void setEnabledGranted(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isEnabledProcessingAction() {
        return this.m_wrappedMenu.isEnabledProcessingAction();
    }

    @Override
    public void setEnabledProcessingAction(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public void setVisiblePermission(Permission p) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_wrappedMenu.isVisibleGranted();
    }

    @Override
    public void setVisibleGranted(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public boolean isToggleAction() {
        return this.m_wrappedMenu.isToggleAction();
    }

    @Override
    public void setToggleAction(boolean b) {
        throw new UnsupportedOperationException("read only wrapper");
    }

    @Override
    public char getMnemonic() {
        return this.m_wrappedMenu.getMnemonic();
    }

    @Override
    public void prepareAction() {
        this.m_wrappedMenu.prepareAction();
    }

    @Override
    public IActionUIFacade getUIFacade() {
        return this.m_wrappedMenu.getUIFacade();
    }

    @Override
    public int acceptVisitor(IActionVisitor visitor) {
        switch (visitor.visit(this)) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                this.visitChildren(visitor);
                return 0;
            }
        }
        return this.visitChildren(visitor);
    }

    private int visitChildren(IActionVisitor visitor) {
        for (IAction iAction : this.getChildActions()) {
            switch (iAction.acceptVisitor(visitor)) {
                case 0: {
                    return 0;
                }
            }
        }
        return 1;
    }

    @Override
    public boolean isThisAndParentsEnabled() {
        return this.m_wrappedMenu.isThisAndParentsEnabled();
    }

    @Override
    public boolean isThisAndParentsVisible() {
        return this.m_wrappedMenu.isThisAndParentsVisible();
    }

    @Override
    public ITypeWithClassId getContainer() {
        return this.m_wrappedMenu.getContainer();
    }

    @Override
    public void setContainerInternal(ITypeWithClassId container) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_wrappedMenu.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_wrappedMenu.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_wrappedMenu.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_wrappedMenu.removePropertyChangeListener(propertyName, listener);
    }

    public String classId() {
        return this.m_wrappedMenu.classId();
    }

    @Override
    public Set<IMenuType> getMenuTypes() {
        return CollectionUtility.hashSet(this.m_menuTypes);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " wrapping '" + this.m_wrappedMenu.toString() + "'";
    }
}

