/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@ClassId(value="b5783a42-9fd8-4043-afc1-6e744dad9c8f")
public class UnsavedFormChangesForm
extends AbstractForm {
    private final List<IForm> m_forms;

    public UnsavedFormChangesForm(List<IForm> forms) throws ProcessingException {
        this.m_forms = forms;
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"UnsavedChangesTitle");
    }

    @Override
    protected boolean getConfiguredAskIfNeedSave() {
        return false;
    }

    public void startNew() throws ProcessingException {
        this.startInternal(new NewHandler());
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getFieldByClass(MainBox.CancelButton.class);
    }

    public MainBox getMainBox() {
        return this.getFieldByClass(MainBox.class);
    }

    public MainBox.UnsavedChangesBox getUnsavedChangesBox() {
        return this.getFieldByClass(MainBox.UnsavedChangesBox.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.UnsavedChangesBox.OpenFormsField getOpenFormsField() {
        return this.getFieldByClass(MainBox.UnsavedChangesBox.OpenFormsField.class);
    }

    public List<IForm> getUnsavedForms() {
        return CollectionUtility.arrayList(this.m_forms);
    }

    private static String getFormDisplayName(IForm f) {
        return StringUtility.nvl((Object)f.getTitle(), (String)f.getClass().getName());
    }

    @Order(value=10.0)
    @ClassId(value="7c89cc91-2c09-472b-af3b-ee93b50caaad")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Order(value=30.0)
        @ClassId(value="50c8526a-333f-4878-9876-b48f2b583d88")
        public class CancelButton
        extends AbstractCancelButton {
            @Override
            protected String getConfiguredTooltipText() {
                return TEXTS.get((String)"CancelShutdownAndReturnToTheApplication");
            }
        }

        @Order(value=20.0)
        @ClassId(value="caca3d68-b8cc-4cb0-a35c-5b8ccbcc3745")
        public class OkButton
        extends AbstractOkButton {
            @Override
            protected String getConfiguredTooltipText() {
                return TEXTS.get((String)"SaveCheckedFormsAndShutdown");
            }
        }

        @Order(value=10.0)
        @ClassId(value="51908aa1-6409-44fd-9aeb-a92cec73baaa")
        public class UnsavedChangesBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"SaveChangesOfSelectedItems");
            }

            @Override
            protected String getConfiguredBorderDecoration() {
                return "line";
            }

            @Override
            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            @Order(value=30.0)
            @ClassId(value="923e159b-3e29-4604-9532-c1a274f89aa8")
            public class CheckAllButton
            extends AbstractButton {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"CheckAllWithMnemonic");
                }

                @Override
                protected void execClickAction() throws ProcessingException {
                    UnsavedFormChangesForm.this.getOpenFormsField().checkAllKeys();
                }
            }

            @Order(value=20.0)
            @ClassId(value="84f2a9cf-bce5-4379-aede-11d07b21d3fb")
            public class OpenFormsField
            extends AbstractListBox<IForm> {
                @Override
                protected void execInitField() throws ProcessingException {
                    this.checkAllKeys();
                }

                public List<IForm> getInvalidForms() {
                    LinkedList<IForm> invalidForms = new LinkedList<IForm>();
                    Iterator iterator = this.getValue().iterator();
                    while (iterator.hasNext()) {
                        IForm f = (IForm)iterator.next();
                        try {
                            f.validateForm();
                        }
                        catch (ProcessingException e) {
                            invalidForms.add(f);
                        }
                    }
                    return invalidForms;
                }

                @Override
                protected Class<? extends ILookupCall<IForm>> getConfiguredLookupCall() {
                    return UnsavedFormsLookupCall.class;
                }

                @Override
                protected void execPrepareLookup(ILookupCall<IForm> call) throws ProcessingException {
                    UnsavedFormsLookupCall unsavedFormsLookupCall = (UnsavedFormsLookupCall)call;
                    unsavedFormsLookupCall.setUnsavedForms(UnsavedFormChangesForm.this.getUnsavedForms());
                }

                @Override
                protected int getConfiguredGridH() {
                    return 5;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }
            }

            @Order(value=30.0)
            @ClassId(value="2cef213f-2278-4d52-9477-512c0c31ca18")
            public class UnCheckAllButton
            extends AbstractButton {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"UncheckAllWithMnemonic");
                }

                @Override
                protected void execClickAction() throws ProcessingException {
                    UnsavedFormChangesForm.this.getOpenFormsField().uncheckAllKeys();
                }
            }
        }
    }

    public class NewHandler
    extends AbstractFormHandler {
        @Override
        protected void execPostLoad() throws ProcessingException {
            UnsavedFormChangesForm.this.touch();
        }

        @Override
        protected boolean execValidate() throws ProcessingException {
            List<IForm> invalidForms = UnsavedFormChangesForm.this.getOpenFormsField().getInvalidForms();
            if (invalidForms.size() > 0) {
                StringBuilder msg = new StringBuilder(TEXTS.get((String)"FormsCannotBeSaved"));
                msg.append("\n\n");
                for (IForm f : invalidForms) {
                    msg.append("- ").append(UnsavedFormChangesForm.getFormDisplayName(f)).append("\n");
                }
                MessageBox.showOkMessage(TEXTS.get((String)"NotAllCheckedFormsCanBeSaved"), TEXTS.get((String)"NotAllCheckedFormsCanBeSaved"), msg.toString());
                return false;
            }
            return true;
        }

        @Override
        protected void execStore() throws ProcessingException {
            Iterator iterator = UnsavedFormChangesForm.this.getOpenFormsField().getValue().iterator();
            while (iterator.hasNext()) {
                IForm f = (IForm)iterator.next();
                f.doOk();
            }
        }
    }

    @ClassId(value="70052229-e6e5-43f3-bac5-cabe6e4525d3")
    public static class UnsavedFormsLookupCall
    extends LocalLookupCall<IForm> {
        private static final long serialVersionUID = 1L;
        private List<IForm> m_unsavedForms;

        public void setUnsavedForms(List<IForm> unsavedForms) {
            this.m_unsavedForms = unsavedForms;
        }

        protected List<? extends ILookupRow<IForm>> execCreateLookupRows() throws ProcessingException {
            ArrayList<LookupRow> formRows = new ArrayList<LookupRow>();
            for (IForm f : this.m_unsavedForms) {
                String text = UnsavedFormChangesForm.getFormDisplayName(f);
                formRows.add(new LookupRow((Object)f, text, null, text));
            }
            return formRows;
        }
    }
}

