/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.annotations.ColumnData;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldTable;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

@FormData(value=AbstractTableRowData.class, sdkCommand=FormData.SdkCommand.USE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE)
public class ContentAssistFieldTable<KEY>
extends AbstractTable
implements IContentAssistFieldTable<KEY> {
    @Override
    protected boolean getConfiguredAutoResizeColumns() {
        return true;
    }

    @Override
    protected boolean getConfiguredHeaderVisible() {
        return false;
    }

    @Override
    protected boolean getConfiguredMultiSelect() {
        return false;
    }

    @Override
    protected boolean getConfiguredMultiCheck() {
        return false;
    }

    @Override
    protected boolean getConfiguredScrollToSelection() {
        return true;
    }

    public KeyColumn getKeyColumn() {
        return this.getColumnSet().getColumnByClass(KeyColumn.class);
    }

    public TextColumn getTextColumn() {
        return this.getColumnSet().getColumnByClass(TextColumn.class);
    }

    protected void decorateCellWithLookupRow(Cell cell, ITableRow row) {
        ILookupRow lookupRow = (ILookupRow)this.getKeyColumn().getValue(row);
        cell.setTooltipText(lookupRow.getTooltipText());
        cell.setBackgroundColor(lookupRow.getBackgroundColor());
        cell.setForegroundColor(lookupRow.getForegroundColor());
        cell.setFont(lookupRow.getFont());
        if (lookupRow.getIconId() != null) {
            cell.setIconId(lookupRow.getIconId());
        }
    }

    @Override
    public void setLookupRows(List<? extends ILookupRow<KEY>> lookupRows) throws ProcessingException {
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>();
        for (ILookupRow<KEY> lookupRow : lookupRows) {
            ITableRow row = this.createRow();
            row.getCellForUpdate(this.getKeyColumn()).setValue(lookupRow);
            rows.add(row);
            row.setEnabled(lookupRow.isEnabled());
            AbstractTableRowData tableRowBean = lookupRow.getAdditionalTableRowData();
            if (tableRowBean == null) continue;
            ITableRowDataMapper mapper = this.createTableRowDataMapper(tableRowBean.getClass());
            mapper.importTableRowData(row, tableRowBean);
        }
        try {
            this.setTableChanging(true);
            this.discardAllRows();
            this.addRows(rows);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public List<ILookupRow<KEY>> getLookupRows() {
        return this.getKeyColumn().getValues();
    }

    @Override
    public ILookupRow<KEY> getSelectedLookupRow() {
        return (ILookupRow)this.getKeyColumn().getSelectedValue();
    }

    @Override
    public ILookupRow<KEY> getCheckedLookupRow() {
        return (ILookupRow)this.getKeyColumn().getValue((ITableRow)CollectionUtility.firstElement(this.getCheckedRows()));
    }

    @Override
    public boolean select(ILookupRow<KEY> lookupRow) throws ProcessingException {
        Object key = null;
        if (lookupRow != null) {
            key = lookupRow.getKey();
        }
        return this.select((KEY)key);
    }

    @Override
    public boolean select(KEY key) throws ProcessingException {
        for (ITableRow row : this.getRows()) {
            if (!CompareUtility.equals(key, (Object)((ILookupRow)this.getKeyColumn().getValue(row)).getKey())) continue;
            this.selectRow(row);
            if (this.isCheckable()) {
                this.checkRow(row, true);
            }
            return true;
        }
        return false;
    }

    @Order(value=10.0)
    @ColumnData(value=ColumnData.SdkColumnCommand.IGNORE)
    public class KeyColumn
    extends AbstractColumn<ILookupRow<KEY>> {
        @Override
        protected String getConfiguredHeaderText() {
            return TEXTS.get((String)"Key");
        }

        @Override
        protected int getConfiguredWidth() {
            return 100;
        }

        @Override
        protected boolean getConfiguredVisible() {
            return false;
        }

        @Override
        protected boolean getConfiguredDisplayable() {
            return false;
        }

        @Override
        protected boolean getConfiguredPrimaryKey() {
            return true;
        }
    }

    @Order(value=20.0)
    @ColumnData(value=ColumnData.SdkColumnCommand.IGNORE)
    public class TextColumn
    extends AbstractStringColumn {
        @Override
        protected String getConfiguredHeaderText() {
            return TEXTS.get((String)"Text");
        }

        @Override
        protected void execDecorateCell(Cell cell, ITableRow row) {
            ILookupRow lookupRow = (ILookupRow)ContentAssistFieldTable.this.getKeyColumn().getValue(row);
            cell.setText(lookupRow.getText());
            ContentAssistFieldTable.this.decorateCellWithLookupRow(cell, row);
        }

        @Override
        protected int getConfiguredWidth() {
            return 200;
        }
    }
}

