/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.rt.server.services.common.security.internal;

import java.util.Collection;

import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotification;

public class AccessControlCacheChangedClusterNotification implements IClusterNotification {
  private static final long serialVersionUID = 128460814967537176L;

  private final Collection<String> m_userIds;

  public Collection<String> getUserIds() {
    return m_userIds;
  }

  public AccessControlCacheChangedClusterNotification(Collection<String> userIds) {
    m_userIds = userIds;
  }

  public AccessControlCacheChangedClusterNotification() {
    this(null);
  }
}
