/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Date;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.admin.inspector.CallInspector;
import org.eclipse.scout.rt.server.admin.inspector.ProcessInspector;
import org.eclipse.scout.rt.server.admin.inspector.SessionInspector;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.transaction.AbstractTransactionMember;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.security.RemoteServiceAccessPermission;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;
import org.eclipse.scout.rt.shared.servicetunnel.RemoteServiceAccessDenied;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.servicetunnel.VersionMismatchException;
import org.eclipse.scout.rt.shared.validate.DefaultValidator;
import org.eclipse.scout.rt.shared.validate.IValidationStrategy;
import org.eclipse.scout.rt.shared.validate.InputValidation;
import org.eclipse.scout.rt.shared.validate.OutputValidation;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.IService2;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.service.ServiceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class DefaultTransactionDelegate {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultTransactionDelegate.class);
    private static final Boolean VALIDATE_INPUT = "true".equals(Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.rt.server.validateInput"));
    private static final Boolean VALIDATE_OUTPUT = "true".equals(Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.rt.server.validateOutput"));
    public static final Pattern DEFAULT_QUERY_NAMES_PATTERN = Pattern.compile("(get|is|has|load|read|find|select)([A-Z].*)?");
    public static final Pattern DEFAULT_PROCESS_NAMES_PATTERN = Pattern.compile("(set|put|add|remove|store|write|create|insert|update|delete)([A-Z].*)?");
    private final Version m_requestMinVersion;
    private final boolean m_debug;
    private final Bundle[] m_loaderBundles;
    private long m_requestStart;
    private long m_requestEnd;

    public DefaultTransactionDelegate(Bundle[] loaderBundles, Version requestMinVersion, boolean debug) {
        this.m_loaderBundles = loaderBundles;
        this.m_requestMinVersion = requestMinVersion;
        this.m_debug = debug;
    }

    public ServiceTunnelResponse invoke(ServiceTunnelRequest serviceReq) throws Exception {
        ServiceTunnelResponse response;
        block14: {
            this.m_requestStart = System.nanoTime();
            try {
                try {
                    response = this.invokeImpl(serviceReq);
                }
                catch (Throwable t) {
                    ITransaction transaction = ThreadContext.getTransaction();
                    try {
                        if (transaction != null) {
                            transaction.addFailure(t);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (transaction == null || !transaction.isCancelled()) {
                        if (t instanceof ProcessingException) {
                            ((ProcessingException)t).addContextMessage("invoking " + serviceReq.getServiceInterfaceClassName() + ":" + serviceReq.getOperation());
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException((ProcessingException)t);
                        } else {
                            LOG.error("invoking " + serviceReq.getServiceInterfaceClassName() + ":" + serviceReq.getOperation(), t);
                        }
                    }
                    Throwable p = this.replaceOutboundException(t);
                    response = new ServiceTunnelResponse(null, null, p);
                    if (this.m_debug) {
                        LOG.debug("TIME " + serviceReq.getServiceInterfaceClassName() + "." + serviceReq.getOperation() + " " + (this.m_requestEnd - this.m_requestStart) / 1000000L + "ms");
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (this.m_debug) {
                    LOG.debug("TIME " + serviceReq.getServiceInterfaceClassName() + "." + serviceReq.getOperation() + " " + (this.m_requestEnd - this.m_requestStart) / 1000000L + "ms");
                }
                throw throwable;
            }
            if (this.m_debug) {
                LOG.debug("TIME " + serviceReq.getServiceInterfaceClassName() + "." + serviceReq.getOperation() + " " + (this.m_requestEnd - this.m_requestStart) / 1000000L + "ms");
            }
        }
        this.m_requestEnd = System.nanoTime();
        response.setProcessingDuration(Long.valueOf((this.m_requestEnd - this.m_requestStart) / 1000000L));
        return response;
    }

    protected Throwable replaceOutboundException(Throwable t) {
        ProcessingException p;
        if (t instanceof VetoException) {
            VetoException ve = (VetoException)t;
            p = new VetoException(ve.getStatus().getTitle(), ve.getMessage(), ve.getStatus().getCode(), ve.getStatus().getSeverity());
        } else {
            p = new ProcessingException(ScoutTexts.get((String)"RequestProblem", (String[])new String[0]));
        }
        p.setStackTrace(new StackTraceElement[0]);
        return p;
    }

    protected ServiceTunnelResponse invokeImpl(ServiceTunnelRequest serviceReq) throws Throwable {
        ServiceTunnelResponse serviceTunnelResponse;
        block28: {
            Set consumedNotifications;
            String soapOperation = ServiceTunnelRequest.toSoapOperation((String)serviceReq.getServiceInterfaceClassName(), (String)serviceReq.getOperation());
            IServerSession serverSession = ThreadContext.getServerSession();
            String authenticatedUser = serverSession.getUserId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("started " + serviceReq.getServiceInterfaceClassName() + "." + serviceReq.getOperation() + " by " + authenticatedUser + " at " + new Date());
            }
            if (this.m_requestMinVersion != null) {
                Version requestVersion;
                String v = serviceReq.getVersion();
                if (v == null) {
                    v = "0.0.0";
                }
                if ((requestVersion = Version.parseVersion((String)v)).compareTo((Object)this.m_requestMinVersion) < 0) {
                    ServiceTunnelResponse serviceRes = new ServiceTunnelResponse(null, null, (Throwable)new VersionMismatchException(requestVersion.toString(), this.m_requestMinVersion.toString()));
                    return serviceRes;
                }
            }
            if ((consumedNotifications = serviceReq.getConsumedNotifications()) != null && consumedNotifications.size() > 0) {
                IClientNotificationService notificationService = (IClientNotificationService)SERVICES.getService(IClientNotificationService.class);
                notificationService.ackNotifications(consumedNotifications);
            }
            CallInspector callInspector = null;
            SessionInspector sessionInspector = ProcessInspector.getDefault().getSessionInspector(serverSession, true);
            if (sessionInspector != null) {
                callInspector = sessionInspector.requestCallInspector(serviceReq);
            }
            ServiceTunnelResponse serviceRes = null;
            try {
                Class<?> serviceInterfaceClass = SerializationUtility.getClassLoader().loadClass(serviceReq.getServiceInterfaceClassName());
                Method serviceOp = ServiceUtility.getServiceOperation(serviceInterfaceClass, (String)serviceReq.getOperation(), (Class[])serviceReq.getParameterTypes());
                this.checkRemoteServiceAccessByInterface(serviceInterfaceClass, serviceOp, serviceReq.getArgs());
                Object service = SERVICES.getService(serviceInterfaceClass);
                if (service == null) {
                    throw new SecurityException("service registry does not contain a service of type " + serviceReq.getServiceInterfaceClassName());
                }
                this.checkRemoteServiceAccessByAnnotations(serviceInterfaceClass, service.getClass(), serviceOp, serviceReq.getArgs());
                this.checkRemoteServiceAccessByPermission(serviceInterfaceClass, service.getClass(), serviceOp, serviceReq.getArgs());
                if (serviceReq.getArgs() != null && serviceReq.getArgs().length > 0) {
                    Class<? extends IValidationStrategy> inputValidationStrategyClass = this.findInputValidationStrategyByAnnotation(service, serviceOp);
                    if (inputValidationStrategyClass == null) {
                        inputValidationStrategyClass = this.findInputValidationStrategyByPolicy(service, serviceOp);
                    }
                    if (inputValidationStrategyClass == null) {
                        throw new SecurityException("input validation failed (no strategy defined)");
                    }
                    this.validateInput(inputValidationStrategyClass.newInstance(), service, serviceOp, serviceReq.getArgs());
                }
                Object data = ServiceUtility.invoke((Method)serviceOp, (Object)service, (Object[])serviceReq.getArgs());
                Object[] outParameters = ServiceUtility.extractHolderArguments((Object[])serviceReq.getArgs());
                if (data != null || outParameters != null && outParameters.length > 0) {
                    Class<? extends IValidationStrategy> outputValidationStrategyClass = this.findOutputValidationStrategyByAnnotation(service, serviceOp);
                    if (outputValidationStrategyClass == null) {
                        outputValidationStrategyClass = this.findOutputValidationStrategyByPolicy(service, serviceOp);
                    }
                    if (outputValidationStrategyClass == null) {
                        throw new SecurityException("output validation failed");
                    }
                    this.validateOutput(outputValidationStrategyClass.newInstance(), service, serviceOp, data, outParameters);
                }
                serviceRes = new ServiceTunnelResponse(data, outParameters, null);
                serviceRes.setSoapOperation(soapOperation);
                ThreadContext.getTransaction().registerMember(new P_ClientNotificationTransactionMember(serviceRes));
                serviceTunnelResponse = serviceRes;
                if (callInspector == null) break block28;
            }
            catch (Throwable throwable) {
                if (callInspector != null) {
                    try {
                        callInspector.update();
                    }
                    catch (Throwable t) {
                        LOG.warn(null, t);
                    }
                    try {
                        callInspector.close(serviceRes);
                    }
                    catch (Throwable t) {
                        LOG.warn(null, t);
                    }
                    try {
                        callInspector.getSessionInspector().update();
                    }
                    catch (Throwable t) {
                        LOG.warn(null, t);
                    }
                }
                throw throwable;
            }
            try {
                callInspector.update();
            }
            catch (Throwable t) {
                LOG.warn(null, t);
            }
            try {
                callInspector.close(serviceRes);
            }
            catch (Throwable t) {
                LOG.warn(null, t);
            }
            try {
                callInspector.getSessionInspector().update();
            }
            catch (Throwable t) {
                LOG.warn(null, t);
            }
        }
        return serviceTunnelResponse;
    }

    protected void checkRemoteServiceAccessByInterface(Class<?> interfaceClass, Method interfaceMethod, Object[] args) {
        Method verifyMethod;
        if (!interfaceClass.isInterface()) {
            throw new SecurityException("access denied (code 1a).");
        }
        if (!IService.class.isAssignableFrom(interfaceClass)) {
            throw new SecurityException("access denied (code 1b).");
        }
        try {
            verifyMethod = interfaceClass.getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
        }
        catch (Throwable t) {
            throw new SecurityException("access denied (code 1c).");
        }
        if (verifyMethod.getDeclaringClass() == IService.class || verifyMethod.getDeclaringClass() == IService2.class) {
            throw new SecurityException("access denied (code 1d).");
        }
    }

    protected void checkRemoteServiceAccessByAnnotations(Class<?> interfaceClass, Class<?> implClass, Method interfaceMethod, Object[] args) {
        Class<?> c = implClass;
        while (c != null) {
            Annotation ann;
            int n;
            int n2;
            Annotation[] annotationArray;
            AccessibleObject m = null;
            try {
                m = c.getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m != null) {
                annotationArray = m.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    ann = annotationArray[n];
                    if (ann.annotationType() == RemoteServiceAccessDenied.class) {
                        throw new SecurityException("access denied (code 2b).");
                    }
                    ++n;
                }
            }
            annotationArray = c.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                ann = annotationArray[n];
                if (ann.annotationType() == RemoteServiceAccessDenied.class) {
                    throw new SecurityException("access denied (code 2c).");
                }
                ++n;
            }
            if (c == interfaceClass) break;
            if ((c = c.getSuperclass()) != Object.class) continue;
            c = interfaceClass;
        }
    }

    protected void checkRemoteServiceAccessByPermission(Class<?> interfaceClass, Class<?> implClass, Method interfaceMethod, Object[] args) {
        if (ACCESS.check((Permission)new RemoteServiceAccessPermission(interfaceClass.getName(), interfaceMethod.getName()))) {
            return;
        }
        throw new SecurityException("access denied (code 3a).");
    }

    protected void validateInput(IValidationStrategy validationStrategy, Object service, Method op, Object[] args) throws Exception {
    }

    protected void defaultValidateInput(IValidationStrategy validationStrategy, Object service, Method op, Object[] args) throws Exception {
        new DefaultValidator(validationStrategy).validateMethodCall(op, args);
    }

    protected void validateOutput(IValidationStrategy validationStrategy, Object service, Method op, Object returnValue, Object[] outArgs) throws Exception {
    }

    protected void defaultValidateOutput(IValidationStrategy validationStrategy, Object service, Method op, Object returnValue, Object[] outArgs) throws Exception {
        if (outArgs != null && outArgs.length > 0 || returnValue != null) {
            DefaultValidator v = new DefaultValidator(validationStrategy);
            if (outArgs != null && outArgs.length > 0) {
                Object[] objectArray = outArgs;
                int n = outArgs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object arg = objectArray[n2];
                    v.validateParameter(arg, null);
                    ++n2;
                }
            }
            if (returnValue != null) {
                v.validateParameter(returnValue, null);
            }
        }
    }

    protected Class<? extends IValidationStrategy> findInputValidationStrategyByAnnotation(Object serviceImpl, Method op) {
        Class<?> c = serviceImpl.getClass();
        while (c != null) {
            InputValidation ann;
            Method m = null;
            try {
                m = c.getMethod(op.getName(), op.getParameterTypes());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m != null && (ann = m.getAnnotation(InputValidation.class)) != null) {
                return ann.value();
            }
            ann = c.getAnnotation(InputValidation.class);
            if (ann != null) {
                return ann.value();
            }
            if (c == op.getDeclaringClass()) break;
            if ((c = c.getSuperclass()) != Object.class) continue;
            c = op.getDeclaringClass();
        }
        return null;
    }

    protected Class<? extends IValidationStrategy> findInputValidationStrategyByPolicy(Object serviceImpl, Method op) {
        if (DEFAULT_QUERY_NAMES_PATTERN.matcher(op.getName()).matches()) {
            return IValidationStrategy.QUERY.class;
        }
        if (DEFAULT_PROCESS_NAMES_PATTERN.matcher(op.getName()).matches()) {
            return IValidationStrategy.PROCESS.class;
        }
        this.warnMissingInputValidation(serviceImpl, op);
        return IValidationStrategy.QUERY.class;
    }

    protected void warnMissingInputValidation(Object serviceImpl, Method op) {
        LOG.warn("Legacy security hint for: " + op.getDeclaringClass().getName() + "#" + op.getName() + ": missing either annotation " + InputValidation.class.getSimpleName() + " or override of server-side " + this.getClass().getSimpleName() + "#findInputValidationStrategyByPolicy. To support legacy the QUERY strategy is used.");
    }

    protected Class<? extends IValidationStrategy> findOutputValidationStrategyByAnnotation(Object serviceImpl, Method op) {
        Class<?> c = serviceImpl.getClass();
        while (c != null) {
            OutputValidation ann;
            Method m = null;
            try {
                m = c.getMethod(op.getName(), op.getParameterTypes());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m != null && (ann = m.getAnnotation(OutputValidation.class)) != null) {
                return ann.value();
            }
            ann = c.getAnnotation(OutputValidation.class);
            if (ann != null) {
                return ann.value();
            }
            if (c == op.getDeclaringClass()) break;
            if ((c = c.getSuperclass()) != Object.class) continue;
            c = op.getDeclaringClass();
        }
        return null;
    }

    protected Class<? extends IValidationStrategy> findOutputValidationStrategyByPolicy(Object serviceImpl, Method op) {
        return IValidationStrategy.NO_CHECK.class;
    }

    private static class P_ClientNotificationTransactionMember
    extends AbstractTransactionMember {
        private static final String TRANSACTION_MEMBER_ID = P_ClientNotificationTransactionMember.class.getSimpleName();
        private final ServiceTunnelResponse m_serviceTunnelResponse;

        public P_ClientNotificationTransactionMember(ServiceTunnelResponse serviceRes) {
            super(TRANSACTION_MEMBER_ID);
            this.m_serviceTunnelResponse = serviceRes;
        }

        @Override
        public boolean needsCommit() {
            return true;
        }

        @Override
        public boolean commitPhase1() {
            return true;
        }

        @Override
        public void commitPhase2() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void release() {
            Set<IClientNotification> nextNotifications = ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).getNextNotifications(0L);
            this.m_serviceTunnelResponse.setClientNotifications(nextNotifications);
        }
    }
}

