/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.IServerSessionProvider;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.server.transaction.BasicTransaction;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.server.transaction.internal.ActiveTransactionRegistry;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TextsThreadLocal;

public abstract class ServerJob
extends JobEx
implements IServerSessionProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerJob.class);
    private static final String CUSTOM_CLASSLOADER_PROPERTY = "org.eclipse.scout.rt.server.customServerJobClassloader";
    private final IServerSession m_serverSession;
    private Subject m_subject;
    private long m_transactionSequence;
    private final boolean m_useCustomClassLoader;

    public ServerJob(String name, IServerSession serverSession) {
        this(name, serverSession, null);
    }

    public ServerJob(String name, IServerSession serverSession, Subject subject) {
        super(name);
        if (serverSession == null) {
            throw new IllegalArgumentException("serverSession is null");
        }
        this.m_serverSession = serverSession;
        this.m_subject = subject;
        this.m_useCustomClassLoader = this.isUseCustomClassloader();
    }

    private boolean isUseCustomClassloader() {
        try {
            return StringUtility.parseBoolean((String)Activator.getDefault().getBundle().getBundleContext().getProperty(CUSTOM_CLASSLOADER_PROPERTY));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean belongsTo(Object family) {
        return family == ServerJob.class;
    }

    @Override
    public IServerSession getServerSession() {
        return this.m_serverSession;
    }

    public Subject getSubject() {
        return this.m_subject;
    }

    public void setSubject(Subject subject) {
        if (this.getState() != 0) {
            throw new IllegalStateException("This job is already scheduled/running");
        }
        this.m_subject = subject;
    }

    public long getTransactionSequence() {
        return this.m_transactionSequence;
    }

    public void setTransactionSequence(long seq) {
        if (this.getState() != 0) {
            throw new IllegalStateException("This job is already scheduled/running");
        }
        this.m_transactionSequence = seq;
    }

    public boolean shouldSchedule() {
        if (this.getServerSession() != null && this.getServerSession().isSingleThreadSession()) {
            this.runNow((IProgressMonitor)new NullProgressMonitor());
            return false;
        }
        return super.shouldSchedule();
    }

    public final IStatus runNow(IProgressMonitor monitor) {
        return super.runNow(monitor);
    }

    protected final IStatus run(final IProgressMonitor monitor) {
        try {
            if (this.m_subject != null) {
                try {
                    return Subject.doAs(this.m_subject, new PrivilegedExceptionAction<IStatus>(){

                        @Override
                        public IStatus run() throws Exception {
                            return ServerJob.this.runTransactionWrapper(monitor);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Throwable t = e.getCause();
                    if (t instanceof ProcessingException) {
                        return ((ProcessingException)t).getStatus();
                    }
                    return new ProcessingStatus(t.getMessage(), t, 0, 4);
                }
            }
            return this.runTransactionWrapper(monitor);
        }
        catch (Throwable t) {
            if (t instanceof ProcessingException) {
                return ((ProcessingException)t).getStatus();
            }
            return new ProcessingStatus(t.getMessage(), t, 0, 4);
        }
    }

    private IStatus runTransactionWrapper(IProgressMonitor monitor) throws Exception {
        ITransaction transaction = this.createNewTransaction();
        Map<Class, Object> backup = ThreadContext.backup();
        Locale oldLocale = LocaleThreadLocal.get();
        ScoutTexts oldTexts = TextsThreadLocal.get();
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            IStatus status;
            ThreadContext.putServerSession(this.m_serverSession);
            ThreadContext.putTransaction(transaction);
            LocaleThreadLocal.set((Locale)this.m_serverSession.getLocale());
            TextsThreadLocal.set((ScoutTexts)this.m_serverSession.getTexts());
            ActiveTransactionRegistry.register(transaction);
            if (this.m_useCustomClassLoader) {
                Thread.currentThread().setContextClassLoader(SerializationUtility.getClassLoader());
            }
            if ((status = this.runTransaction(monitor)) == null) {
                status = Status.OK_STATUS;
            }
            IStatus iStatus = status;
            return iStatus;
        }
        catch (Throwable t) {
            ProcessingException pe;
            Throwable test;
            if (t instanceof UndeclaredThrowableException && (test = ((UndeclaredThrowableException)t).getUndeclaredThrowable()) != null) {
                t = test;
            }
            if (t.getCause() instanceof ProcessingException) {
                t = t.getCause();
            }
            transaction.addFailure(t);
            String contextMsg = "Identity=" + ServerJob.getIdentity() + ", Job=" + this.getName();
            if (t instanceof ProcessingException) {
                pe = (ProcessingException)t;
                pe.addContextMessage(contextMsg);
            } else {
                pe = new ProcessingException(contextMsg, t);
            }
            throw pe;
        }
        finally {
            ActiveTransactionRegistry.unregister(transaction);
            if (transaction.hasFailures()) {
                try {
                    transaction.rollback();
                }
                catch (Throwable t) {
                    LOG.error("Transaction rollback failed with exception.", t);
                }
            } else {
                boolean needRollback = false;
                try {
                    if (transaction.commitPhase1()) {
                        transaction.commitPhase2();
                    } else {
                        needRollback = true;
                    }
                }
                catch (Throwable t) {
                    needRollback = true;
                    LOG.error("Transaction commit exception.", t);
                }
                if (needRollback) {
                    try {
                        transaction.rollback();
                    }
                    catch (Throwable t) {
                        LOG.error("Transaction rollback failed with exception.", t);
                    }
                }
            }
            try {
                transaction.release();
            }
            catch (Throwable t) {
                LOG.warn(null, t);
            }
            try {
                ThreadContext.restore(backup);
            }
            catch (Throwable t) {
                LOG.warn(null, t);
            }
            LocaleThreadLocal.set((Locale)oldLocale);
            TextsThreadLocal.set((ScoutTexts)oldTexts);
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    protected abstract IStatus runTransaction(IProgressMonitor var1) throws Exception;

    public static final IServerSession getCurrentSession() {
        return ServerJob.getCurrentSession(IServerSession.class);
    }

    public static final <T extends IServerSession> T getCurrentSession(Class<T> type) {
        IServerSession s = ThreadContext.getServerSession();
        if (s != null && type.isAssignableFrom(s.getClass())) {
            return (T)s;
        }
        return null;
    }

    public static String getIdentity() {
        Iterator<Principal> iterator;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && (iterator = subject.getPrincipals().iterator()).hasNext()) {
            Principal p = iterator.next();
            return p.getName();
        }
        return "anonymous";
    }

    protected ITransaction createNewTransaction() {
        return new BasicTransaction(this.getTransactionSequence());
    }
}

