/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.inspector;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.admin.inspector.CallInspector;
import org.eclipse.scout.rt.server.admin.inspector.ProcessInspector;
import org.eclipse.scout.rt.server.admin.inspector.info.SessionInfo;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;

public class SessionInspector {
    private ProcessInspector m_parent;
    private IServerSession m_session;
    private SessionInfo m_info;
    private Object m_callListLock = new Object();
    private ArrayList<CallInspector> m_callList = new ArrayList();

    protected SessionInspector(ProcessInspector parent, IServerSession session) {
        this.m_parent = parent;
        this.m_session = session;
        this.m_info = new SessionInfo();
        this.m_info.setSessionId(session.getId());
        this.m_info.setUserId(session.getUserId());
        this.m_info.setUserAgent(session.getUserAgent());
        try {
            this.m_info.setSubject(Subject.getSubject(AccessController.getContext()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProcessInspector getProcessInspector() {
        return this.m_parent;
    }

    public IServerSession getServerSession() {
        return this.m_session;
    }

    public SessionInfo getInfo() {
        return this.m_info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallInspector[] getCallInspectors() {
        Object object = this.m_callListLock;
        synchronized (object) {
            return this.m_callList.toArray(new CallInspector[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallInspector requestCallInspector(ServiceTunnelRequest call) {
        Object object = this.m_callListLock;
        synchronized (object) {
            if (this.getProcessInspector().isEnabled() && this.getProcessInspector().acceptCall(call.getServiceInterfaceClassName(), call.getOperation())) {
                CallInspector callInspector = new CallInspector(this, call);
                this.m_callList.add(callInspector);
                return callInspector;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCallInspectors() {
        Object object = this.m_callListLock;
        synchronized (object) {
            this.m_callList.clear();
        }
    }

    public void doHousekeeping(long timeoutMillis) {
        this.manageCallInspectorList(timeoutMillis);
    }

    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageCallInspectorList(long timeoutMillis) {
        Object object = this.m_callListLock;
        synchronized (object) {
            Iterator<CallInspector> it = this.m_callList.iterator();
            while (it.hasNext()) {
                CallInspector c = it.next();
                if (c.isTimeout(timeoutMillis)) {
                    it.remove();
                    continue;
                }
                c.update();
            }
        }
    }
}

