/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.scout.commons.LRUCache;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.IStatementCache;
import org.eclipse.scout.rt.server.transaction.AbstractTransactionMember;

public class PreparedStatementCache
extends AbstractTransactionMember
implements IStatementCache {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PreparedStatementCache.class);
    public static final String TRANSACTION_MEMBER_ID = "PreparedStatementCache";
    private LRUCache<String, Integer> m_countCache = new LRUCache(200, 120000L);
    private LRUCache<String, PreparedStatement> m_statementCache;

    public PreparedStatementCache(int statementCacheSize) {
        super(TRANSACTION_MEMBER_ID);
        this.m_statementCache = new LRUCache(statementCacheSize, 3600000L);
        this.m_statementCache.addDisposeListener(new LRUCache.DisposeListener(){

            public void valueDisposed(Object key, Object value) {
                PreparedStatement ps = (PreparedStatement)value;
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    LOG.warn("disposing prepared statement");
                }
            }
        });
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection conn, String s) throws SQLException {
        PreparedStatement ps = (PreparedStatement)this.m_statementCache.get((Object)s);
        if (ps == null) {
            ps = conn.prepareStatement(s);
            Integer count = (Integer)this.m_countCache.get((Object)s);
            count = (count != null ? count : 0) + 1;
            this.m_countCache.put((Object)s, (Object)count);
            if (count >= 2) {
                this.m_statementCache.put((Object)s, (Object)ps);
            }
        } else {
            ps.clearParameters();
            ps.clearWarnings();
        }
        return ps;
    }

    @Override
    public void releasePreparedStatement(PreparedStatement ps) {
        if (ps != null && !this.m_statementCache.containsValue((Object)ps)) {
            try {
                ps.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public CallableStatement getCallableStatement(Connection conn, String s) throws SQLException {
        CallableStatement cs = (CallableStatement)this.m_statementCache.get((Object)s);
        if (cs == null) {
            cs = conn.prepareCall(s);
            Integer count = (Integer)this.m_countCache.get((Object)s);
            count = (count != null ? count : 0) + 1;
            this.m_countCache.put((Object)s, (Object)count);
            if (count >= 2) {
                this.m_statementCache.put((Object)s, (Object)cs);
            }
        }
        return cs;
    }

    @Override
    public void releaseCallableStatement(CallableStatement cs) {
        if (cs != null && !this.m_statementCache.containsValue((Object)cs)) {
            try {
                cs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean needsCommit() {
        return false;
    }

    @Override
    public boolean commitPhase1() {
        return true;
    }

    @Override
    public void commitPhase2() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public void release() {
        this.m_statementCache.clear();
        this.m_countCache.clear();
    }
}

