/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate.checks;

import java.lang.reflect.Array;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.validate.DefaultValidator;
import org.eclipse.scout.rt.shared.validate.checks.IValidateCheck;

public class MasterValueRequiredCheck
implements IValidateCheck {
    public static final String ID = "masterValueRequired";
    private DefaultValidator.FormDataCheckContext m_ctx;

    public MasterValueRequiredCheck(DefaultValidator.FormDataCheckContext ctx) {
        this.m_ctx = ctx;
    }

    @Override
    public String getCheckId() {
        return ID;
    }

    @Override
    public boolean accept(Object obj) {
        return true;
    }

    @Override
    public void check(Object s) throws Exception {
        Class masterFieldClass = (Class)this.m_ctx.ruleMap.get("masterValueField");
        if (masterFieldClass == null) {
            throw new ProcessingException(String.valueOf(this.m_ctx.fieldName) + " missing master field");
        }
        AbstractValueFieldData masterField = (AbstractValueFieldData)this.m_ctx.formData.getFieldByClass(masterFieldClass);
        if (masterField == null) {
            throw new ProcessingException(String.valueOf(this.m_ctx.fieldName) + " missing master field " + masterFieldClass.getSimpleName());
        }
        Object masterValue = masterField.getValue();
        if (masterValue == null || masterValue.getClass().isArray() && Array.getLength(masterValue) == 0) {
            throw new ProcessingException(String.valueOf(this.m_ctx.fieldName) + " slave is set but master is null: " + masterFieldClass.getSimpleName() + " -> " + this.m_ctx.fieldName);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.m_ctx.fieldName;
    }
}

