/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.ui.rap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.WaitCondition;
import org.eclipse.scout.rt.testing.ui.rap.RAPSelenium;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.ColorUtility;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.ext.DropDownButton;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.testing.client.AbstractGuiMock;
import org.eclipse.scout.testing.client.IGuiMock;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverService;

public class RapMock
extends AbstractGuiMock {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RapMock.class);
    private static DriverService m_service = null;
    private WebDriver m_driver;
    private RAPSelenium m_bot;
    private int m_sleepDelay = 40;
    private final ElementFinder m_elementFinder = new ElementFinder(new JavascriptLibrary());
    private String m_currentWidgetId = "";
    private WebElement m_currentElement = null;
    private boolean m_modifierPressed = false;
    private Actions m_actionBuilder = null;
    private static boolean useChrome = false;
    private static boolean useFirefox = !useChrome;
    private static boolean useFirebug = false;

    public RapMock() {
        super(null);
    }

    public void initializeMock() {
        if (useChrome) {
            m_service = new ChromeDriverService.Builder().usingDriverExecutable(new File("e:/Downloads/java/chromedriver.exe")).usingAnyFreePort().build();
        }
        try {
            if (m_service != null) {
                m_service.start();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("ChromeDriverService could not be started.", e);
        }
    }

    public void shutdownMock() {
        if (m_service != null) {
            m_service.stop();
        }
    }

    public void beforeTest() {
        if (m_service != null) {
            if (useChrome) {
                DesiredCapabilities chrome = DesiredCapabilities.chrome();
                this.m_driver = new RemoteWebDriver(m_service.getUrl(), (Capabilities)chrome);
            }
        } else if (useFirefox) {
            System.setProperty("webdriver.firefox.bin", "C:/FirefoxPortableTest_11/App/Firefox/firefox.exe");
            FirefoxProfile firefoxProfile = new FirefoxProfile();
            if (useFirebug) {
                try {
                    firefoxProfile.addExtension(new File("E:/Downloads/java/firebug-1.9.2-fx.xpi"));
                    firefoxProfile.setPreference("extensions.firebug.currentVersion", "1.9.2");
                    firefoxProfile.addExtension(new File("E:/Downloads/java/firepath-0.9.7-fx.xpi"));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not add/find firefox extensions.", e);
                }
            }
            this.m_driver = new FirefoxDriver(firefoxProfile);
        }
        if (this.m_driver == null) {
            throw new NullPointerException("no driver instantiated!");
        }
        this.m_bot = new RAPSelenium(this.m_driver, "http://localhost:8081");
        this.m_actionBuilder = new Actions(this.m_bot.getWrappedDriver());
        this.m_bot.open("http://localhost:8081/rap");
        this.m_bot.waitForElementPresent("w2");
    }

    public void afterTest() {
        this.m_driver.quit();
    }

    public IGuiMock.GuiStrategy getStrategy() {
        return IGuiMock.GuiStrategy.Rap;
    }

    public void setCurrentWidgetId(String currentWidgetId) {
        this.m_currentWidgetId = currentWidgetId;
        this.m_currentElement = this.m_elementFinder.findElement(this.m_bot.getWrappedDriver(), currentWidgetId);
    }

    public String getCurrentWidgetId_() {
        return this.m_currentWidgetId;
    }

    public WebElement getCurrentElement() {
        return this.m_currentElement;
    }

    public void waitForIdle() {
        if (this.getDisplay().getThread() == Thread.currentThread()) {
            return;
        }
        int pass = 0;
        while (pass < 1) {
            this.syncExec(new WaitCondition<Object>(){

                public Object run() throws Throwable {
                    return null;
                }
            });
            ClientSyncJob idleJob = new ClientSyncJob("Check for idle", this.getClientSession()){

                protected void runVoid(IProgressMonitor m) throws Throwable {
                }
            };
            idleJob.setSystem(true);
            final CountDownLatch idleJobScheduledSignal = new CountDownLatch(1);
            JobChangeAdapter listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    idleJobScheduledSignal.countDown();
                }
            };
            try {
                idleJob.addJobChangeListener((IJobChangeListener)listener);
                idleJob.schedule();
                try {
                    idleJobScheduledSignal.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Interrupted");
                }
            }
            finally {
                idleJob.removeJobChangeListener((IJobChangeListener)listener);
            }
            ++pass;
        }
    }

    public void waitForActiveWindow(final String title) {
        this.waitUntil(new WaitCondition<Object>(){

            public Object run() {
                if (RapMock.this.isWindowActive(title)) {
                    return true;
                }
                return null;
            }
        });
        this.waitForIdle();
    }

    public void waitForOpenWindow(final String title) {
        this.waitUntil(new WaitCondition<Object>(){

            public Object run() {
                if (RapMock.this.isWindowOpen(title)) {
                    return true;
                }
                return null;
            }
        });
        this.waitForIdle();
    }

    public int getSleepDelay() {
        return this.m_sleepDelay;
    }

    public void setSleepDelay(int sleepDelay) {
        this.m_sleepDelay = sleepDelay;
    }

    public void sleep() {
        this.sleep(this.getSleepDelay());
    }

    public void sleep(int millis) {
        if (this.getDisplay().getThread() == Thread.currentThread()) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.waitForIdle();
    }

    public boolean isWindowActive(final String title) {
        return this.syncExec(new WaitCondition<Boolean>(){

            public Boolean run() throws Throwable {
                CTabItem view = RapMock.this.findWorkbenchView(title);
                if (view != null && view.getParent().getSelection() == view) {
                    return true;
                }
                Shell shell = RapMock.this.findShell(title);
                if (shell != null && shell == RapMock.this.getActiveShell()) {
                    return true;
                }
                return false;
            }
        });
    }

    public boolean isWindowOpen(final String title) {
        return this.syncExec(new WaitCondition<Boolean>(){

            public Boolean run() throws Throwable {
                CTabItem view = RapMock.this.findWorkbenchView(title);
                if (view != null) {
                    return true;
                }
                Shell shell = RapMock.this.findShell(title);
                if (shell != null) {
                    return true;
                }
                return false;
            }
        });
    }

    public void activateWindow(final String title) {
        this.waitForOpenWindow(title);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                CTabItem view = RapMock.this.findWorkbenchView(title);
                if (view != null) {
                    view.getParent().setSelection(view);
                    return null;
                }
                Shell shell = RapMock.this.findShell(title);
                if (shell != null) {
                    shell.setActive();
                    return null;
                }
                throw new IllegalStateException("There is no view with title " + title);
            }
        });
        this.waitForIdle();
    }

    public IGuiMock.FieldState getFieldState(IGuiMock.FieldType type, int index) {
        final Control c = this.waitForIndexedField(type, index);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                return RapMock.this.getFieldStateInternal(c);
            }
        });
    }

    public IGuiMock.FieldState getScoutFieldState(String name) {
        final Control c = this.waitForScoutField(name);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                return RapMock.this.getFieldStateInternal(c);
            }
        });
    }

    public IGuiMock.FieldState getScoutFieldContainerState(String name) {
        final Control c = this.waitForScoutField(name);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                IRwtScoutComposite swtScoutComposite = RwtScoutComposite.getCompositeOnWidget((Widget)c);
                if (swtScoutComposite == null) {
                    return null;
                }
                return RapMock.this.getFieldStateInternal((Control)swtScoutComposite.getUiContainer());
            }
        });
    }

    public List<IGuiMock.FieldState> getFieldStates(final IGuiMock.FieldType type) {
        return this.syncExec(new WaitCondition<List<IGuiMock.FieldState>>(){

            public List<IGuiMock.FieldState> run() throws Throwable {
                ArrayList<IGuiMock.FieldState> list = new ArrayList<IGuiMock.FieldState>();
                for (Control c : RwtUtility.findChildComponents((Widget)RapMock.this.getActiveShell(), Control.class)) {
                    if (type == null && RapMock.this.getFieldTypeOf(c) != null) {
                        list.add(RapMock.this.getFieldStateInternal(c));
                        continue;
                    }
                    if (type == null || RapMock.this.getFieldTypeOf(c) != type) continue;
                    list.add(RapMock.this.getFieldStateInternal(c));
                }
                return list;
            }
        });
    }

    public IGuiMock.FieldState getFocusFieldState() {
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                Control c = RapMock.this.getDisplay().getFocusControl();
                if (c == null) {
                    throw new IllegalStateException("There is no focus owner");
                }
                return RapMock.this.getFieldStateInternal(c);
            }
        });
    }

    public void clickOnPushButton(String text) {
        final Control c = this.waitForPushButtonWithLabel(text);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Point p = c.toDisplay(5, 5);
                RapMock.this.gotoPoint(p.x, p.y);
                RapMock.this.clickLeft();
                return null;
            }
        });
        this.waitForIdle();
    }

    public void gotoField(IGuiMock.FieldType type, int index) {
        Control c = this.waitForIndexedField(type, index);
        this.setCurrentWidgetId(WidgetUtil.getAdapter((Widget)c).getId());
        if (IGuiMock.FieldType.Text.equals((Object)type)) {
            this.setCurrentWidgetId(new StringBuffer("//*[@id=\"").append(this.getCurrentWidgetId_()).append("\"]/input").toString());
        }
    }

    public void gotoScoutField(String name) {
        this.gotoScoutField(name, 0.5, 0.5);
    }

    public void gotoScoutField(String name, double x, double y) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("x should be in [0, 1] range.");
        }
        if (y < 0.0 || y > 1.0) {
            throw new IllegalArgumentException("y should be in [0, 1] range.");
        }
        Control c = this.waitForScoutField(name);
        this.setCurrentWidgetId(WidgetUtil.getAdapter((Widget)c).getId());
        if (c instanceof Text) {
            this.setCurrentWidgetId(new StringBuffer("//*[@id=\"").append(this.getCurrentWidgetId_()).append("\"]/input").toString());
        }
    }

    public void gotoTable(int tableIndex, final int rowIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                RapMock.this.setCurrentWidgetId(WidgetUtil.getAdapter((Widget)table).getId());
                StringBuffer xpathWidgetId = new StringBuffer("//*[@id=\"").append(RapMock.this.getCurrentWidgetId_()).append("\"]/div[1]/div[").append(rowIndex + table.getColumnCount()).append("]/div");
                if (columnIndex > 0) {
                    xpathWidgetId.append("[").append(columnIndex).append("]");
                }
                RapMock.this.setCurrentWidgetId(xpathWidgetId.toString());
                return null;
            }
        });
    }

    public void gotoTableHeader(int tableIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                int curIndex = -1;
                int accumulatedWidth = 0;
                Rectangle cellBounds = null;
                int[] nArray = table.getColumnOrder();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    TableColumn col = table.getColumn(i);
                    if (i > 0 && ++curIndex == columnIndex) {
                        cellBounds = new Rectangle(accumulatedWidth, 0, col.getWidth(), table.getHeaderHeight());
                        break;
                    }
                    accumulatedWidth += col.getWidth();
                    ++n2;
                }
                cellBounds.x -= table.getHorizontalBar().getSelection();
                Point p = table.toDisplay(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
                RapMock.this.gotoPoint(p.x, p.y);
                return null;
            }
        });
    }

    public void gotoTree(int treeIndex, final String nodeText) {
        final Tree tree = (Tree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                RapMock.this.setCurrentWidgetId(WidgetUtil.getAdapter((Widget)tree).getId());
                TreeItem[] items = tree.getItems();
                int i = 0;
                while (i < items.length) {
                    if (nodeText.equals(items[i].getText())) {
                        StringBuffer xpathWidgetId = new StringBuffer("//*[@id=\"").append(RapMock.this.getCurrentWidgetId_()).append("\"]/div[1]/div[").append(i + 1).append("]/div[2]");
                        RapMock.this.setCurrentWidgetId(xpathWidgetId.toString());
                        break;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    public void contextMenu(String ... names) {
        int i = 0;
        while (i < names.length) {
            String label = names[i];
            final boolean lastItem = i == names.length - 1;
            final MenuItem m = this.waitForMenuItem(label);
            this.syncExec(new WaitCondition<Boolean>(){

                public Boolean run() throws Throwable {
                    if ((m.getStyle() & 0x30) != 0) {
                        m.setSelection(!m.getSelection());
                    }
                    Event event = new Event();
                    event.display = RapMock.this.getDisplay();
                    event.time = (int)System.currentTimeMillis();
                    event.type = 13;
                    event.widget = m;
                    m.notifyListeners(event.type, event);
                    return null;
                }
            });
            this.waitForIdle();
            ++i;
        }
    }

    public List<String> getTableCells(int tableIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<List<String>>(){

            public List<String> run() throws Throwable {
                ArrayList<String> list = new ArrayList<String>();
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem row = tableItemArray[n2];
                    list.add(row.getText(columnIndex + 1));
                    ++n2;
                }
                return list;
            }
        });
    }

    public List<String> getTreeNodes(int treeIndex) {
        final Tree tree = (Tree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        return this.syncExec(new WaitCondition<List<String>>(){

            public List<String> run() throws Throwable {
                ArrayList<String> list = new ArrayList<String>();
                RapMock.this.addTreeItemsRec(tree.getItems(), list);
                return list;
            }
        });
    }

    public Set<String> getSelectedTableCells(int tableIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> set = new TreeSet<String>();
                TableItem[] sel = table.getSelection();
                if (sel != null) {
                    TableItem[] tableItemArray = sel;
                    int n = sel.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem row = tableItemArray[n2];
                        set.add(row.getText(columnIndex + 1));
                        ++n2;
                    }
                }
                return set;
            }
        });
    }

    public Set<String> getSelectedTreeNodes(int treeIndex) {
        final Tree tree = (Tree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> set = new TreeSet<String>();
                TreeItem[] sel = tree.getSelection();
                if (sel != null) {
                    TreeItem[] treeItemArray = sel;
                    int n = sel.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem row = treeItemArray[n2];
                        set.add(row.getText(0));
                        ++n2;
                    }
                }
                return set;
            }
        });
    }

    public Set<String> getCheckedTableCells(int tableIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> check = new TreeSet<String>();
                int i = 0;
                while (i < table.getItemCount()) {
                    ITableRow row;
                    TableItem item = table.getItem(i);
                    if (item.getData() instanceof ITableRow && (row = (ITableRow)item.getData()).isChecked()) {
                        check.add(item.getText(columnIndex + 1));
                    }
                    ++i;
                }
                return check;
            }
        });
    }

    public void gotoPoint(int x, int y) {
        Control c = this.waitForLocatedField(x, y);
        this.setCurrentWidgetId(WidgetUtil.getAdapter((Widget)c).getId());
    }

    public void move(int deltaX, int deltaY) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void clickLeft() {
        this.m_bot.clickAndWait(this.getCurrentWidgetId_());
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Control focusControl = Display.getCurrent().getFocusControl();
                RapMock.this.setCurrentWidgetId(WidgetUtil.getAdapter((Widget)focusControl).getId());
                return null;
            }
        });
    }

    public void clickRight() {
        this.m_actionBuilder.contextClick(this.getCurrentElement());
        this.m_actionBuilder.perform();
        this.waitForIdle();
    }

    public void drag(int x1, int y1, int x2, int y2) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void dragWindowRightBorder(IGuiMock.WindowState windowState, int pixelToMoveOnX) {
        int borderSize = 4;
        int xPos = windowState.x + windowState.width + borderSize;
        int yPos = windowState.y + windowState.height / 2;
        this.drag(xPos, yPos, xPos + pixelToMoveOnX, yPos);
    }

    public void typeText(String text) {
        if (this.m_modifierPressed) {
            this.m_actionBuilder.sendKeys(new CharSequence[]{text.toUpperCase()});
        } else {
            this.m_actionBuilder.sendKeys(new CharSequence[]{text}).perform();
            this.waitForIdle();
        }
    }

    public void paste(String text) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void pressKey(IGuiMock.Key key) {
        switch (key) {
            case Shift: {
                this.m_actionBuilder.keyDown(Keys.SHIFT);
                this.m_modifierPressed = true;
                break;
            }
            case Control: {
                this.m_actionBuilder.keyDown(Keys.CONTROL);
                this.m_modifierPressed = true;
                break;
            }
            case Alt: {
                this.m_actionBuilder.keyDown(Keys.ALT);
                this.m_modifierPressed = true;
                break;
            }
            case Windows: {
                this.m_actionBuilder.keyDown(Keys.META);
                this.m_modifierPressed = true;
                break;
            }
            default: {
                this.m_actionBuilder.sendKeys(new CharSequence[]{this.toSeleniumKey(key).toString()});
                this.m_actionBuilder.perform();
                this.waitForIdle();
            }
        }
    }

    public void releaseKey(IGuiMock.Key key) {
        switch (key) {
            case Shift: {
                this.m_actionBuilder.keyUp(Keys.SHIFT);
                this.m_modifierPressed = false;
                break;
            }
            case Control: {
                this.m_actionBuilder.keyUp(Keys.CONTROL);
                this.m_modifierPressed = false;
                break;
            }
            case Alt: {
                this.m_actionBuilder.keyUp(Keys.ALT);
                this.m_modifierPressed = false;
                break;
            }
            case Windows: {
                this.m_actionBuilder.keyUp(Keys.META);
                this.m_modifierPressed = false;
                break;
            }
            default: {
                this.m_actionBuilder.keyUp(this.toSeleniumKey(key));
            }
        }
        this.m_actionBuilder.perform();
        this.waitForIdle();
    }

    public void typeKey(IGuiMock.Key key) {
        if (this.m_modifierPressed) {
            this.m_actionBuilder.sendKeys(new CharSequence[]{this.toSeleniumKey(key)}).perform();
        } else {
            this.m_actionBuilder.sendKeys(this.getCurrentElement(), new CharSequence[]{this.toSeleniumKey(key)}).perform();
        }
        this.waitForIdle();
    }

    public IGuiMock.WindowState getWindowState(final String title) {
        return this.syncExec(new WaitCondition<IGuiMock.WindowState>(){

            public IGuiMock.WindowState run() throws Throwable {
                RapMock.this.checkActiveShell();
                CTabItem view = RapMock.this.findWorkbenchView(title);
                if (view != null) {
                    IGuiMock.WindowState state = new IGuiMock.WindowState();
                    Point p = view.getParent().toDisplay(0, 0);
                    Point s = view.getParent().getSize();
                    state.x = p.x;
                    state.y = p.y;
                    state.width = s.x;
                    state.height = s.y;
                    return state;
                }
                Shell shell = RapMock.this.findShell(title);
                if (shell != null) {
                    Rectangle r = shell.getBounds();
                    IGuiMock.WindowState state = new IGuiMock.WindowState();
                    state.x = r.x;
                    state.y = r.y;
                    state.width = r.width;
                    state.height = r.height;
                    return state;
                }
                throw new IllegalStateException("Window " + title + " not found");
            }
        });
    }

    public String getClipboardText() {
        this.waitForIdle();
        return this.syncExec(new WaitCondition<String>(){

            public String run() throws Throwable {
                return "";
            }
        });
    }

    public void setClipboardText(String value) {
        this.waitForIdle();
        this.syncExec(new WaitCondition<Object>(){

            public String run() throws Throwable {
                return null;
            }
        });
    }

    public Object internal0(Object o) {
        return this.syncExec(new WaitCondition<String>(){

            public String run() throws Throwable {
                return null;
            }
        });
    }

    protected void checkActiveShell() {
        if (this.getActiveShell() == null) {
            throw new IllegalStateException("There is no active shell");
        }
    }

    protected IGuiMock.FieldState getFieldStateInternal(Control c) {
        IGuiMock.FieldState state = new IGuiMock.FieldState();
        state.type = this.getFieldTypeOf(c);
        IPropertyObserver scoutObject = RwtScoutComposite.getScoutModelOnWidget((Widget)c);
        state.scoutName = scoutObject != null ? scoutObject.getClass().getName() : null;
        state.focus = c == this.getDisplay().getFocusControl();
        Point p = c.toDisplay(0, 0);
        state.x = p.x;
        state.y = p.y;
        state.width = c.getBounds().width;
        state.height = c.getBounds().height;
        state.foregroundColor = ColorUtility.createStringFromColor((Color)c.getForeground());
        state.backgroundColor = ColorUtility.createStringFromColor((Color)c.getBackground());
        if (c instanceof Label) {
            state.text = ((Label)c).getText();
        }
        if (c instanceof Text) {
            state.text = ((Text)c).getText();
        }
        if (c instanceof StyledText) {
            state.text = ((StyledText)c).getText();
        }
        if (c instanceof Button) {
            Button button = (Button)c;
            state.text = button.getText();
            state.selected = button.getSelection();
        }
        state.visible = c.isVisible();
        state.widget = c;
        return state;
    }

    protected IGuiMock.FieldType getFieldTypeOf(Control c) {
        if (c.isDisposed()) {
            return null;
        }
        if (!c.isVisible()) {
            return null;
        }
        if (c instanceof Label) {
            return IGuiMock.FieldType.Label;
        }
        if (c instanceof Text) {
            return IGuiMock.FieldType.Text;
        }
        if (c instanceof StyledText) {
            return IGuiMock.FieldType.Text;
        }
        if (c instanceof Table) {
            return IGuiMock.FieldType.Table;
        }
        if (c instanceof Tree) {
            return IGuiMock.FieldType.Tree;
        }
        if (c instanceof DropDownButton) {
            return IGuiMock.FieldType.DropdownButton;
        }
        if (c instanceof Button) {
            int style = c.getStyle();
            if ((style & 0x20) != 0) {
                return IGuiMock.FieldType.Checkbox;
            }
            if ((style & 0x10) != 0) {
                return IGuiMock.FieldType.RadioButton;
            }
            if (c.getParent() instanceof Scrollable) {
                return IGuiMock.FieldType.ScrollButton;
            }
            return IGuiMock.FieldType.PushButton;
        }
        return null;
    }

    protected String getScoutNameOf(Control c) {
        IPropertyObserver scoutObject = RwtScoutComposite.getScoutModelOnWidget((Widget)c);
        if (scoutObject != null) {
            return scoutObject.getClass().getName();
        }
        return null;
    }

    protected Display getDisplay() {
        IRwtEnvironment env = (IRwtEnvironment)this.getClientSession().getData("ui.environment");
        return env.getDisplay();
    }

    protected Shell getActiveShell() {
        return this.getDisplay().getActiveShell();
    }

    protected String cleanButtonLabel(String s) {
        return StringUtility.removeMnemonic((String)s);
    }

    protected TreeItem findTreeItemRec(TreeItem[] items, String nodeText) {
        if (items == null) {
            return null;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (nodeText.equals(item.getText())) {
                return item;
            }
            TreeItem found = this.findTreeItemRec(item.getItems(), nodeText);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    protected void addTreeItemsRec(TreeItem[] items, List<String> list) {
        if (items == null) {
            return;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            list.add(item.getText(0));
            this.addTreeItemsRec(item.getItems(), list);
            ++n2;
        }
    }

    protected List<Composite> enumerateParentContainers() {
        return this.syncExec(new WaitCondition<ArrayList<Composite>>(){

            public ArrayList<Composite> run() throws Throwable {
                ArrayList<Composite> list = new ArrayList<Composite>();
                Shell[] shellArray = RapMock.this.getDisplay().getShells();
                int n = shellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (shell.isVisible()) {
                        list.add((Composite)shell);
                    }
                    ++n2;
                }
                return list;
            }
        });
    }

    protected Shell findShell(String title) {
        Shell[] shellArray = this.getDisplay().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (title.equals(shell.getText())) {
                return shell;
            }
            ++n2;
        }
        return null;
    }

    protected CTabItem findWorkbenchView(String title) {
        return null;
    }

    protected Control waitForPushButtonWithLabel(final String label) {
        return this.waitUntil(new WaitCondition<Control>(){

            public Control run() {
                return RapMock.this.syncExec(new WaitCondition<Control>(){

                    public Control run() throws Throwable {
                        Shell[] shellArray = RapMock.this.getDisplay().getShells();
                        int n = shellArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Shell shell;
                            Shell parent = shell = shellArray[n2];
                            for (Control o : RwtUtility.findChildComponents((Widget)parent, Control.class)) {
                                if (!(o instanceof Button) || !RapMock.this.cleanButtonLabel(label).equals(RapMock.this.cleanButtonLabel(((Button)o).getText()))) continue;
                                return o;
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected Control waitForScoutField(final String name) {
        return this.waitUntil(new WaitCondition<Control>(){

            public Control run() {
                return RapMock.this.syncExec(new WaitCondition<Control>(){

                    public Control run() throws Throwable {
                        Control lastSecondaryCandidate = null;
                        for (Composite parent : RapMock.this.enumerateParentContainers()) {
                            for (Control c : RwtUtility.findChildComponents((Widget)parent, Control.class)) {
                                String s = RapMock.this.getScoutNameOf(c);
                                if (s == null || !("." + s).endsWith("." + name)) continue;
                                lastSecondaryCandidate = c;
                                if (RapMock.this.getFieldTypeOf(c) == null) continue;
                                return c;
                            }
                        }
                        return lastSecondaryCandidate;
                    }
                });
            }
        });
    }

    protected Control waitForIndexedField(final IGuiMock.FieldType type, final int fieldIndex) {
        return this.waitUntil(new WaitCondition<Control>(){

            public Control run() {
                return RapMock.this.syncExec(new WaitCondition<Control>(){

                    public Control run() throws Throwable {
                        List<Composite> parents = RapMock.this.enumerateParentContainers();
                        for (Composite parent : parents) {
                            int index = 0;
                            for (Control c : RwtUtility.findChildComponents((Widget)parent, Control.class)) {
                                if (RapMock.this.getFieldTypeOf(c) != type) continue;
                                if (index == fieldIndex) {
                                    return c;
                                }
                                ++index;
                            }
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected Control waitForLocatedField(final int x, final int y) {
        return this.waitUntil(new WaitCondition<Control>(){

            public Control run() {
                return RapMock.this.syncExec(new WaitCondition<Control>(){

                    public Control run() throws Throwable {
                        List<Composite> parents = RapMock.this.enumerateParentContainers();
                        for (Composite parent : parents) {
                            for (Control c : RwtUtility.findChildComponents((Widget)parent, Control.class, Composite.class)) {
                                Rectangle map = RapMock.this.getDisplay().map(c, null, c.getBounds());
                                if (!map.contains(x, y)) continue;
                                return c;
                            }
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected MenuItem waitForMenuItem(final String name) {
        return this.waitUntil(new WaitCondition<MenuItem>(){

            public MenuItem run() {
                return RapMock.this.syncExec(new WaitCondition<MenuItem>(){

                    public MenuItem run() throws Throwable {
                        MenuItem item;
                        int n;
                        int n2;
                        MenuItem[] menuItemArray;
                        Menu m;
                        Menu m2;
                        String label = RapMock.this.cleanButtonLabel(name);
                        Control focusControl = RapMock.this.getDisplay().getFocusControl();
                        if (focusControl != null && (m2 = focusControl.getMenu()) != null) {
                            MenuItem[] menuItemArray2 = m2.getItems();
                            int n3 = menuItemArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                MenuItem item2 = menuItemArray2[n4];
                                if (label.equals(RapMock.this.cleanButtonLabel(item2.getText()))) {
                                    return item2;
                                }
                                ++n4;
                            }
                        }
                        for (Composite parent : RapMock.this.enumerateParentContainers()) {
                            for (Control c : RwtUtility.findChildComponents((Widget)parent, Control.class)) {
                                m = c.getMenu();
                                if (m == null) continue;
                                menuItemArray = m.getItems();
                                n2 = menuItemArray.length;
                                n = 0;
                                while (n < n2) {
                                    item = menuItemArray[n];
                                    if (label.equals(RapMock.this.cleanButtonLabel(item.getText()))) {
                                        return item;
                                    }
                                    ++n;
                                }
                            }
                        }
                        Shell[] shellArray = RapMock.this.getDisplay().getShells();
                        int n5 = shellArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Shell shell = shellArray[n6];
                            m = shell.getMenuBar();
                            if (m != null) {
                                menuItemArray = m.getItems();
                                n2 = menuItemArray.length;
                                n = 0;
                                while (n < n2) {
                                    item = menuItemArray[n];
                                    if (label.equals(RapMock.this.cleanButtonLabel(item.getText()))) {
                                        return item;
                                    }
                                    ++n;
                                }
                            }
                            ++n6;
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected <T> T syncExec(final WaitCondition<T> r) {
        if (this.getDisplay().getThread() != Thread.currentThread()) {
            final AtomicReference ret = new AtomicReference();
            final AtomicReference ex = new AtomicReference();
            try {
                this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ret.set(RapMock.this.syncExec(r));
                        }
                        catch (Throwable t) {
                            ex.set(t);
                        }
                    }
                });
                if (ex.get() != null) {
                    throw (Throwable)ex.get();
                }
                return (T)ret.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        try {
            return (T)r.run();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected <T> T waitUntil(WaitCondition<T> w) {
        try {
            Object object = TestingUtility.waitUntil((long)10000L, w);
            return (T)object;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.waitForIdle();
        }
    }

    public void pressLeft() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void releaseLeft() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void gotoTreeExpandIcon(int treeIndex, String nodeText) {
        throw new UnsupportedOperationException("not implemented");
    }

    protected Keys toSeleniumKey(IGuiMock.Key key) {
        switch (key) {
            case Shift: {
                return Keys.SHIFT;
            }
            case Control: {
                return Keys.CONTROL;
            }
            case Alt: {
                return Keys.ALT;
            }
            case Delete: {
                return Keys.DELETE;
            }
            case Backspace: {
                return Keys.BACK_SPACE;
            }
            case Enter: {
                return Keys.ENTER;
            }
            case Esc: {
                return Keys.ESCAPE;
            }
            case Tab: {
                return Keys.TAB;
            }
            case ContextMenu: {
                throw new IllegalArgumentException("Unknown keyboard key: " + key);
            }
            case Up: {
                return Keys.UP;
            }
            case Down: {
                return Keys.DOWN;
            }
            case Left: {
                return Keys.LEFT;
            }
            case Right: {
                return Keys.RIGHT;
            }
            case Windows: {
                return Keys.META;
            }
            case F1: {
                return Keys.F1;
            }
            case F2: {
                return Keys.F2;
            }
            case F3: {
                return Keys.F3;
            }
            case F4: {
                return Keys.F4;
            }
            case F5: {
                return Keys.F5;
            }
            case F6: {
                return Keys.F6;
            }
            case F7: {
                return Keys.F7;
            }
            case F8: {
                return Keys.F8;
            }
            case F9: {
                return Keys.F9;
            }
            case F10: {
                return Keys.F10;
            }
            case F11: {
                return Keys.F11;
            }
            case F12: {
                return Keys.F12;
            }
            case Home: {
                return Keys.HOME;
            }
            case End: {
                return Keys.END;
            }
            case PageUp: {
                return Keys.PAGE_UP;
            }
            case PageDown: {
                return Keys.PAGE_DOWN;
            }
            case NumPad0: {
                return Keys.NUMPAD0;
            }
            case NumPad1: {
                return Keys.NUMPAD1;
            }
            case NumPad2: {
                return Keys.NUMPAD2;
            }
            case NumPad3: {
                return Keys.NUMPAD3;
            }
            case NumPad4: {
                return Keys.NUMPAD4;
            }
            case NumPad5: {
                return Keys.NUMPAD5;
            }
            case NumPad6: {
                return Keys.NUMPAD6;
            }
            case NumPad7: {
                return Keys.NUMPAD7;
            }
            case NumPad8: {
                return Keys.NUMPAD8;
            }
            case NumPadMultiply: {
                return Keys.MULTIPLY;
            }
            case NumPadDivide: {
                return Keys.DIVIDE;
            }
            case NumPadAdd: {
                return Keys.ADD;
            }
            case NumPadSubtract: {
                return Keys.SUBTRACT;
            }
            case NumPadDecimal: {
                return Keys.DECIMAL;
            }
            case NumPadSeparator: {
                return Keys.SEPARATOR;
            }
        }
        throw new IllegalArgumentException("Unknown keyboard key: " + key);
    }

    protected int toKeyCode(IGuiMock.Key key) {
        switch (key) {
            case Shift: {
                return 16;
            }
            case Control: {
                return 17;
            }
            case Alt: {
                return 18;
            }
            case Delete: {
                return 127;
            }
            case Backspace: {
                return 8;
            }
            case Enter: {
                return 10;
            }
            case Esc: {
                return 27;
            }
            case Tab: {
                return 9;
            }
            case ContextMenu: {
                return 525;
            }
            case Up: {
                return 38;
            }
            case Down: {
                return 40;
            }
            case Left: {
                return 37;
            }
            case Right: {
                return 39;
            }
            case Windows: {
                return 524;
            }
            case F1: {
                return 112;
            }
            case F2: {
                return 113;
            }
            case F3: {
                return 114;
            }
            case F4: {
                return 115;
            }
            case F5: {
                return 116;
            }
            case F6: {
                return 117;
            }
            case F7: {
                return 118;
            }
            case F8: {
                return 119;
            }
            case F9: {
                return 120;
            }
            case F10: {
                return 121;
            }
            case F11: {
                return 122;
            }
            case F12: {
                return 123;
            }
            case Home: {
                return 36;
            }
            case End: {
                return 35;
            }
            case PageUp: {
                return 33;
            }
            case PageDown: {
                return 34;
            }
            case NumPad0: {
                return 96;
            }
            case NumPad1: {
                return 97;
            }
            case NumPad2: {
                return 98;
            }
            case NumPad3: {
                return 99;
            }
            case NumPad4: {
                return 100;
            }
            case NumPad5: {
                return 101;
            }
            case NumPad6: {
                return 102;
            }
            case NumPad7: {
                return 103;
            }
            case NumPad8: {
                return 104;
            }
            case NumPadMultiply: {
                return 106;
            }
            case NumPadDivide: {
                return 111;
            }
            case NumPadAdd: {
                return 107;
            }
            case NumPadSubtract: {
                return 109;
            }
            case NumPadDecimal: {
                return 110;
            }
            case NumPadSeparator: {
                return 108;
            }
        }
        throw new IllegalArgumentException("Unknown keyboard key: " + key);
    }

    public void clickLeftOnSmartFieldMagnifier(IGuiMock.FieldState fieldState) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void clickRightOnSmartFieldMagnifier(IGuiMock.FieldState fieldState) {
        throw new UnsupportedOperationException("not implemented yet");
    }
}

