/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.filechooserfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import org.eclipse.rap.addons.fileupload.DiskFileUploadReceiver;
import org.eclipse.rap.addons.fileupload.FileUploadEvent;
import org.eclipse.rap.addons.fileupload.FileUploadHandler;
import org.eclipse.rap.addons.fileupload.FileUploadListener;
import org.eclipse.rap.addons.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.ScoutFieldStatus;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtScoutContextMenu;
import org.eclipse.scout.rt.ui.rap.ext.DropDownFileUpload;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.filechooserfield.IRwtScoutFileUploadField;
import org.eclipse.scout.rt.ui.rap.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;

public class RwtScoutFileUploadField
extends RwtScoutValueFieldComposite<IFileChooserField>
implements IRwtScoutFileUploadField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutFileUploadField.class);
    private Composite m_fileContainer;
    private DropDownFileUpload m_browseButton;
    private ProgressBar m_progressBar;
    private TextFieldEditableSupport m_editableSupport;
    private FileUploadHandler m_handler;
    private P_FileUploadListener m_uploadListener;
    private File m_uploadedFile = null;
    private String m_originalVariant = "";
    private RwtContextMenuMarkerComposite m_menuMarkerComposite;
    private RwtScoutContextMenu m_uiContextMenu;
    private P_ContextMenuPropertyListener m_contextMenuPropertyListener;

    public RwtScoutFileUploadField() {
        this.initializeFileUpload();
    }

    protected void initializeUi(Composite parent) {
        super.initializeUi(parent);
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_fileContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 2048);
        this.m_fileContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"filechooserfield_file");
        this.m_menuMarkerComposite = new RwtContextMenuMarkerComposite(this.m_fileContainer, this.getUiEnvironment(), 0);
        this.getUiEnvironment().getFormToolkit().adapt((Composite)this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                if (RwtScoutFileUploadField.this.getUiContextMenu() != null) {
                    Menu uiMenu = RwtScoutFileUploadField.this.getUiContextMenu().getUiMenu();
                    if (e.widget instanceof Control) {
                        Point loc = ((Control)e.widget).toDisplay(e.x, e.y);
                        uiMenu.setLocation(RwtMenuUtility.getMenuLocation((List)((IFileChooserField)RwtScoutFileUploadField.this.getScoutObject()).getContextMenu().getChildActions(), (Menu)uiMenu, (Point)loc, (IRwtEnvironment)RwtScoutFileUploadField.this.getUiEnvironment()));
                    }
                    uiMenu.setVisible(true);
                }
            }
        });
        StyledTextEx textField = new StyledTextEx((Composite)this.m_menuMarkerComposite, 4 | this.getUiEnvironment().getFormToolkit().getOrientation()){
            private static final long serialVersionUID = 1L;

            public void setBackground(Color color) {
                if (RwtScoutFileUploadField.this.getUiProgressBar() != null && !RwtScoutFileUploadField.this.getUiProgressBar().isDisposed()) {
                    RwtScoutFileUploadField.this.getUiProgressBar().setBackground(color);
                }
                if (RwtScoutFileUploadField.this.getUiBrowseButton() != null && !RwtScoutFileUploadField.this.getUiBrowseButton().isDisposed()) {
                    RwtScoutFileUploadField.this.getUiBrowseButton().setBackground(color);
                }
            }
        };
        this.getUiEnvironment().getFormToolkit().adapt((Control)textField, false, false);
        textField.setData("org.eclipse.rap.rwt.customVariant", (Object)"filechooserfield_file");
        textField.setEnabled(false);
        this.setUiContainer(container);
        this.setUiLabel((ILabelComposite)label);
        this.setUiField((Control)textField);
        this.createBrowseButton();
        this.m_fileContainer.setTabList(new Control[]{this.m_menuMarkerComposite});
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_fileContainer.setLayoutData((Object)LogicalGridDataBuilder.createField((GridData)((IFormField)this.getScoutObject()).getGridData()));
        this.m_fileContainer.setLayout((Layout)new FormLayout());
        FormData textLayoutData = new FormData(-1, -1);
        textLayoutData.left = new FormAttachment(0, 0);
        textLayoutData.right = new FormAttachment(100, -20);
        textLayoutData.bottom = new FormAttachment((Control)this.m_menuMarkerComposite, -1, 1024);
        this.m_menuMarkerComposite.setLayoutData((Object)textLayoutData);
    }

    private void createBrowseButton() {
        this.m_browseButton = this.getUiEnvironment().getFormToolkit().createDropDownFileUpload(this.m_fileContainer, 4);
        this.m_browseButton.setData("org.eclipse.rap.rwt.customVariant", (Object)"filechooserfield_file");
        this.m_browseButton.addMouseListener((MouseListener)new MouseAdapter(){
            private static final long serialVersionUID = 1L;

            public void mouseDown(MouseEvent e) {
                RwtScoutFileUploadField.this.handleUiInputVerifier(true);
            }
        });
        this.m_browseButton.addFocusListener((FocusListener)new FocusAdapter(){
            private static final long serialVersionUID = 1L;

            public void focusGained(FocusEvent e) {
                RwtScoutFileUploadField.this.getUiField().setFocus();
            }
        });
        this.setBackgroundFromScout(((IFileChooserField)this.getScoutObject()).getBackgroundColor());
        this.getUiBrowseButton().addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                String filename = RwtScoutFileUploadField.this.getUiBrowseButton().getFileName();
                if (filename == null) {
                    return;
                }
                RwtScoutFileUploadField.this.getUiField().setText(filename);
                RwtScoutFileUploadField.this.handleUpload();
            }
        });
        FormData buttonLayoutData = new FormData(-1, -1);
        buttonLayoutData.left = new FormAttachment((Control)this.m_menuMarkerComposite, 0, 131072);
        buttonLayoutData.bottom = new FormAttachment((Control)this.getUiBrowseButton(), 0, 1024);
        buttonLayoutData.height = 20;
        buttonLayoutData.width = 20;
        this.getUiBrowseButton().setLayoutData((Object)buttonLayoutData);
        this.setEnabledFromScout(((IFileChooserField)this.getScoutObject()).isEnabled());
        this.m_fileContainer.layout();
    }

    private void createProgressBar() {
        this.m_progressBar = new ProgressBar(this.m_fileContainer, 0x10100 | this.getUiEnvironment().getFormToolkit().getOrientation());
        this.getUiEnvironment().getFormToolkit().adapt((Control)this.m_progressBar, true, true);
        this.setBackgroundFromScout(((IFileChooserField)this.getScoutObject()).getBackgroundColor());
        FormData progressLayoutData = new FormData(-1, -1);
        progressLayoutData.right = new FormAttachment(100, -20);
        progressLayoutData.left = new FormAttachment(0, 0);
        progressLayoutData.top = new FormAttachment(2, 0);
        progressLayoutData.bottom = new FormAttachment((Control)this.m_progressBar, 4, 1024);
        this.m_progressBar.setLayoutData((Object)progressLayoutData);
        this.m_fileContainer.layout();
    }

    public void disposeImpl() {
        if (this.m_uploadListener != null) {
            this.m_handler.removeUploadListener((FileUploadListener)this.m_uploadListener);
            this.m_uploadListener = null;
        }
        if (this.m_handler != null) {
            this.m_handler.dispose();
            this.m_handler = null;
        }
        if (this.m_browseButton != null) {
            this.m_browseButton.dispose();
            this.m_browseButton = null;
        }
    }

    private void initializeFileUpload() {
        DiskFileUploadReceiver receiver = new DiskFileUploadReceiver();
        this.m_handler = new FileUploadHandler((FileUploadReceiver)receiver);
    }

    @Override
    public DropDownFileUpload getUiBrowseButton() {
        return this.m_browseButton;
    }

    @Override
    public ProgressBar getUiProgressBar() {
        return this.m_progressBar;
    }

    public StyledText getUiField() {
        return (StyledText)super.getUiField();
    }

    public RwtScoutContextMenu getUiContextMenu() {
        return this.m_uiContextMenu;
    }

    protected IRwtKeyStroke[] getUiKeyStrokes() {
        return new IRwtKeyStroke[]{new RwtKeyStroke(27){

            public void handleUiAction(Event e) {
                if (RwtScoutFileUploadField.this.cancelUpload()) {
                    e.doit = false;
                }
            }
        }, new RwtKeyStroke(13){

            public void handleUiAction(Event e) {
                RwtScoutFileUploadField.this.handleUiInputVerifier(e.doit);
            }
        }};
    }

    protected void attachScout() {
        super.attachScout();
        this.setFileIconIdFromScout(((IFileChooserField)this.getScoutObject()).getFileIconId());
        if (((IFileChooserField)this.getScoutObject()).isFolderMode()) {
            String msg = "IFileChooserField.isFolderMode() == true is not possible in RAP";
            LOG.error(msg);
            this.getUiLabel().setStatus((IProcessingStatus)new ProcessingStatus(msg, 4));
        }
        this.updateContextMenuVisibilityFromScout();
        if (((IFileChooserField)this.getScoutObject()).getContextMenu() != null && this.m_contextMenuPropertyListener == null) {
            this.m_contextMenuPropertyListener = new P_ContextMenuPropertyListener();
            ((IFileChooserField)this.getScoutObject()).getContextMenu().addPropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
        }
    }

    protected void detachScout() {
        if (this.m_contextMenuPropertyListener != null) {
            ((IFileChooserField)this.getScoutObject()).getContextMenu().removePropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
            this.m_contextMenuPropertyListener = null;
        }
        super.detachScout();
    }

    protected void setDisplayTextFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getUiField().setText(s);
        super.handleUiFocusGained();
        this.getUiField().setCaretOffset(0);
    }

    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.getUiBrowseButton().setButtonEnabled(b);
        this.getUiField().setEnabled(false);
        if (!StringUtility.hasText((String)this.m_originalVariant)) {
            this.m_originalVariant = (String)this.m_fileContainer.getData("org.eclipse.rap.rwt.customVariant");
        }
        String customVariant = b ? this.m_originalVariant : String.valueOf(this.m_originalVariant) + "-disabled";
        this.m_fileContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)customVariant);
    }

    protected void setFieldEnabled(Control field, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getUiField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    protected void setFileIconIdFromScout(String s) {
        this.m_originalVariant = s;
        this.m_fileContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)s);
        this.getUiField().setData("org.eclipse.rap.rwt.customVariant", (Object)s);
        this.getUiBrowseButton().setData("org.eclipse.rap.rwt.customVariant", (Object)s);
    }

    protected void updateContextMenuVisibilityFromScout() {
        this.m_menuMarkerComposite.setMarkerVisible(((IFileChooserField)this.getScoutObject()).getContextMenu().isVisible());
        if (((IFileChooserField)this.getScoutObject()).getContextMenu().isVisible()) {
            if (this.m_uiContextMenu == null) {
                this.m_uiContextMenu = new RwtScoutContextMenu(this.getUiField().getShell(), (IContextMenu)((IFileChooserField)this.getScoutObject()).getContextMenu(), this.getUiEnvironment());
                if (this.getUiBrowseButton() != null) {
                    this.getUiBrowseButton().setMenu(this.m_uiContextMenu.getUiMenu());
                }
            }
        } else {
            if (this.getUiBrowseButton() != null) {
                this.getUiBrowseButton().setMenu(null);
            }
            if (this.m_uiContextMenu != null) {
                this.m_uiContextMenu.dispose();
            }
            this.m_uiContextMenu = null;
        }
    }

    protected void handleUiInputVerifier(boolean doit) {
        if (!doit) {
            return;
        }
        if (this.m_uploadedFile == null) {
            return;
        }
        if (CompareUtility.equals((Object)this.m_uploadedFile, (Object)((IFileChooserField)this.getScoutObject()).getDisplayText()) && ((IFileChooserField)this.getScoutObject()).getErrorStatus() == null) {
            return;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IFileChooserField)RwtScoutFileUploadField.this.getScoutObject()).getUIFacade().setTextFromUI(RwtScoutFileUploadField.this.m_uploadedFile.getAbsolutePath());
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getUiEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getUiEnvironment().dispatchImmediateUiJobs();
    }

    protected void handleUiFocusGained() {
        super.handleUiFocusGained();
        this.getUiField().setSelection(0, this.getUiField().getText().length());
    }

    protected void handleUiFocusLost() {
        this.getUiField().setSelection(0, 0);
    }

    private void handleUpload() {
        this.m_uploadedFile = null;
        String url = this.m_handler.getUploadUrl();
        if (this.m_uploadListener == null) {
            this.m_uploadListener = new P_FileUploadListener();
        }
        this.m_uploadListener.startUpload();
        this.m_handler.addUploadListener((FileUploadListener)this.m_uploadListener);
        this.createProgressBar();
        this.getUiBrowseButton().submit(url);
    }

    private boolean cancelUpload() {
        ProgressBar uiProgressBar;
        if (this.m_uploadedFile != null) {
            return false;
        }
        if (this.m_uploadListener != null) {
            this.m_handler.removeUploadListener((FileUploadListener)this.m_uploadListener);
            this.m_uploadListener.cancelUpload();
            this.m_uploadListener = null;
        }
        this.m_handler.dispose();
        DropDownFileUpload uiBrowseButton = this.getUiBrowseButton();
        if (uiBrowseButton != null && !uiBrowseButton.isDisposed()) {
            uiBrowseButton.dispose();
        }
        if ((uiProgressBar = this.getUiProgressBar()) != null && !uiProgressBar.isDisposed()) {
            uiProgressBar.dispose();
        }
        this.getUiField().setText("");
        this.initializeFileUpload();
        this.createBrowseButton();
        return true;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("fileIconId")) {
            this.setFileIconIdFromScout((String)newValue);
        }
    }

    private class P_ContextMenuPropertyListener
    implements PropertyChangeListener {
        private P_ContextMenuPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                RwtScoutFileUploadField.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutFileUploadField.this.updateContextMenuVisibilityFromScout();
                    }
                });
            }
        }
    }

    private class P_FileUploadListener
    implements FileUploadListener {
        private final ServerPushSession m_pushSession = new ServerPushSession();
        private int m_oldPercentage = 0;

        public void startUpload() {
            this.m_pushSession.start();
        }

        public void cancelUpload() {
            this.m_pushSession.stop();
        }

        private int getPercentage(FileUploadEvent uploadEvent) {
            double bytesRead = uploadEvent.getBytesRead();
            double contentLength = uploadEvent.getContentLength();
            double fraction = bytesRead / contentLength;
            return (int)Math.floor(fraction * 100.0);
        }

        public void uploadProgress(final FileUploadEvent uploadEvent) {
            RwtScoutFileUploadField.this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int percent = P_FileUploadListener.this.getPercentage(uploadEvent);
                    if (percent != P_FileUploadListener.this.m_oldPercentage && RwtScoutFileUploadField.this.getUiProgressBar() != null && !RwtScoutFileUploadField.this.getUiProgressBar().isDisposed()) {
                        P_FileUploadListener.this.m_oldPercentage = percent;
                        RwtScoutFileUploadField.this.getUiProgressBar().setSelection(percent);
                        RwtScoutFileUploadField.this.getUiProgressBar().setToolTipText("Upload progress: " + percent + "%");
                    }
                }
            });
        }

        public void uploadFinished(FileUploadEvent uploadEvent) {
            DiskFileUploadReceiver receiver = (DiskFileUploadReceiver)RwtScoutFileUploadField.this.m_handler.getReceiver();
            File[] uploadedFiles = receiver.getTargetFiles();
            if (uploadedFiles != null && uploadedFiles.length > 0) {
                RwtScoutFileUploadField.this.m_uploadedFile = uploadedFiles[0];
            } else {
                RwtScoutFileUploadField.this.m_uploadedFile = null;
            }
            RwtScoutFileUploadField.this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RwtScoutFileUploadField.this.m_uploadedFile != null) {
                        RwtScoutFileUploadField.this.handleUiInputVerifier(true);
                    }
                }
            });
            RwtScoutFileUploadField.this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RwtScoutFileUploadField.this.getUiProgressBar() != null && !RwtScoutFileUploadField.this.getUiProgressBar().isDisposed()) {
                        RwtScoutFileUploadField.this.getUiProgressBar().dispose();
                    }
                    RwtScoutFileUploadField.this.m_handler.removeUploadListener((FileUploadListener)RwtScoutFileUploadField.this.m_uploadListener);
                }
            });
            this.m_pushSession.stop();
        }

        public void uploadFailed(final FileUploadEvent uploadEvent) {
            RwtScoutFileUploadField.this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RwtScoutFileUploadField.this.getUiLabel() != null) {
                        RwtScoutFileUploadField.this.getUiLabel().setStatus((IProcessingStatus)new ScoutFieldStatus(uploadEvent.getException().getMessage(), 4));
                    }
                    if (RwtScoutFileUploadField.this.getUiProgressBar() != null && !RwtScoutFileUploadField.this.getUiProgressBar().isDisposed()) {
                        RwtScoutFileUploadField.this.getUiProgressBar().dispose();
                    }
                    RwtScoutFileUploadField.this.m_handler.removeUploadListener((FileUploadListener)RwtScoutFileUploadField.this.m_uploadListener);
                }
            });
            this.m_pushSession.stop();
        }
    }
}

