/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.action.MenuSizeEstimator;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtScoutMenuItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.presentations.util.ISystemMenu;

public final class RwtMenuUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtMenuUtility.class);

    private RwtMenuUtility() {
    }

    public static Point getMenuLocation(List<? extends IMenu> scoutActions, Menu menu, Point proposedLocation, IRwtEnvironment env) {
        int menuHeight = new MenuSizeEstimator(menu).estimateMenuHeight(scoutActions);
        if (RwtMenuUtility.shouldMenuOpenOnTop(proposedLocation, env, menuHeight)) {
            return RwtMenuUtility.computeMenuPositionForTop(proposedLocation, menuHeight);
        }
        return proposedLocation;
    }

    private static boolean shouldMenuOpenOnTop(Point proposedLocation, IRwtEnvironment env, int menuHeight) {
        int displayHeight = env.getDisplay().getBounds().height;
        return proposedLocation.y + menuHeight > displayHeight;
    }

    private static Point computeMenuPositionForTop(Point proposedLocation, int menuHeight) {
        return new Point(proposedLocation.x, proposedLocation.y - menuHeight);
    }

    public static List<IMenu> collectMenus(final ICalendar calendar, final boolean emptySpaceActions, final boolean componentActions, IRwtEnvironment uiEnvironment) {
        final LinkedList<IMenu> menuList = new LinkedList<IMenu>();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(calendar.getUIFacade().fireNewPopupFromUI());
                }
                if (componentActions) {
                    menuList.addAll(calendar.getUIFacade().fireComponentPopupFromUI());
                }
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList;
    }

    public static void fillMenu(Menu menu, List<IMenu> childActions, IActionFilter filter, IRwtEnvironment environment) {
        for (IMenu childMenu : ActionUtility.visibleNormalizedActions(childActions, (IActionFilter)filter)) {
            new RwtScoutMenuItem(childMenu, menu, filter, environment);
        }
    }

    public static MenuItem createRwtMenuItem(Menu parentMenu, IMenu scoutMenu, IActionFilter filter, IRwtEnvironment environment) {
        MenuItem swtMenuItem = null;
        if (scoutMenu.isSeparator()) {
            swtMenuItem = new MenuItem(parentMenu, 2);
        } else if (scoutMenu.hasChildActions()) {
            swtMenuItem = new MenuItem(parentMenu, 64);
            RwtMenuUtility.createChildMenu(swtMenuItem, scoutMenu.getChildActions(), filter, environment);
        } else {
            swtMenuItem = scoutMenu.isToggleAction() ? new MenuItem(parentMenu, 32) : new MenuItem(parentMenu, 8);
        }
        return swtMenuItem;
    }

    public static Menu createChildMenu(MenuItem swtMenuItem, List<IMenu> childActions, IActionFilter filter, IRwtEnvironment environment) {
        Menu menu = new Menu(swtMenuItem);
        RwtMenuUtility.fillMenu(menu, childActions, filter, environment);
        swtMenuItem.setMenu(menu);
        return menu;
    }

    public static <T extends IActionNode<?>> List<T> cleanup(List<T> scoutActionNodes) {
        if (scoutActionNodes == null) {
            return null;
        }
        LinkedList<T> cleanedActions = new LinkedList<T>(scoutActionNodes);
        Iterator it = cleanedActions.iterator();
        while (it.hasNext()) {
            if (!RwtMenuUtility.isExcludedAction((IActionNode)it.next())) continue;
            it.remove();
        }
        return MenuUtility.consolidateMenus(cleanedActions);
    }

    private static boolean isExcludedAction(IActionNode action) {
        return action instanceof ISystemMenu;
    }

    public static boolean hasChildActions(IAction action) {
        if (!(action instanceof IActionNode)) {
            return false;
        }
        IActionNode actionNode = (IActionNode)action;
        return actionNode.hasChildActions();
    }

    public static boolean hasVisibleChildActions(IAction action) {
        if (!(action instanceof IActionNode)) {
            return false;
        }
        IActionNode actionNode = (IActionNode)action;
        for (IActionNode child : actionNode.getChildActions()) {
            if (child.isVisible()) {
                return true;
            }
            if (!child.hasChildActions() || !RwtMenuUtility.hasVisibleChildActions((IAction)child)) continue;
            return true;
        }
        return false;
    }

    public static List<? extends IActionNode> getChildActions(IAction action) {
        if (!(action instanceof IActionNode)) {
            return null;
        }
        IActionNode actionNode = (IActionNode)action;
        if (!actionNode.hasChildActions()) {
            return null;
        }
        return actionNode.getChildActions();
    }
}

