/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfo;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractOpenMenuJob
extends JobEx {
    private Point m_eventPosition;
    private boolean m_openMenu = false;
    private final Control m_UiField;
    private BrowserInfo m_browserInfo = RwtUtility.getBrowserInfo();

    public AbstractOpenMenuJob(Control UiField) {
        super("OpenMenuJob");
        this.m_UiField = UiField;
    }

    public void startOpenJob(Point eventPosition) {
        if (this.m_browserInfo.isTablet() || this.m_browserInfo.isMobile()) {
            this.setEventPosition(eventPosition);
            this.setOpenMenu(true);
            this.schedule(500L);
        }
    }

    public void stopOpenJob() {
        this.setOpenMenu(false);
        if (1 == this.getState() || 2 == this.getState()) {
            this.cancel();
        }
    }

    public boolean openMenuCheck() {
        return this.getUiField() != null && !this.getUiField().isDisposed();
    }

    public abstract void showMenu(Point var1);

    protected IStatus run(IProgressMonitor monitor) {
        if (this.isOpenMenu()) {
            this.getUiField().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractOpenMenuJob.this.openMenuCheck()) {
                        Point pt = AbstractOpenMenuJob.this.getUiField().toDisplay(AbstractOpenMenuJob.this.getEventPosition());
                        pt.x += 50;
                        AbstractOpenMenuJob.this.showMenu(pt);
                    }
                }
            });
        }
        return Status.OK_STATUS;
    }

    private Control getUiField() {
        return this.m_UiField;
    }

    public void setEventPosition(Point eventPosition) {
        this.m_eventPosition = eventPosition;
    }

    public Point getEventPosition() {
        return this.m_eventPosition;
    }

    public void setOpenMenu(boolean openMenu) {
        this.m_openMenu = openMenu;
    }

    public boolean isOpenMenu() {
        return this.m_openMenu;
    }
}

