/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import java.util.HashMap;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.TableColumnManager;
import org.eclipse.swt.graphics.Font;

public class RwtScoutTableModel
implements IStructuredContentProvider,
ITableFontProvider {
    private static final long serialVersionUID = 1L;
    private final ITable m_scoutTable;
    private HashMap<ITableRow, HashMap<IColumn<?>, ICell>> m_cachedCells;
    private final RwtScoutTable m_uiTable;
    private final TableColumnManager m_columnManager;

    public RwtScoutTableModel(ITable scoutTable, RwtScoutTable uiTable, TableColumnManager columnManager) {
        this.m_scoutTable = scoutTable;
        this.m_uiTable = uiTable;
        this.m_columnManager = columnManager;
        this.rebuildCache();
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_scoutTable != null) {
            return this.m_scoutTable.getFilteredRows().toArray();
        }
        return new Object[0];
    }

    public Font getFont(Object element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.getRwtScoutTable().getUiEnvironment().getFont(cell.getFont(), this.getRwtScoutTable().getUiField().getFont());
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void consumeTableModelEvent(RwtScoutTableEvent uiTableEvent) {
        this.rebuildCache();
    }

    protected ICell getCell(Object row, int colIndex) {
        IColumn<?> column = this.m_columnManager.getColumnByModelIndex(colIndex - 1);
        if (column != null) {
            if (this.m_cachedCells.get(row) == null) {
                this.rebuildCache();
            }
            return this.m_cachedCells.get(row).get(column);
        }
        return null;
    }

    private void rebuildCache() {
        this.m_cachedCells = new HashMap();
        if (this.m_scoutTable != null) {
            for (ITableRow scoutRow : this.m_scoutTable.getRows()) {
                HashMap<IColumn, ICell> cells = new HashMap<IColumn, ICell>();
                for (IColumn col : this.m_scoutTable.getColumnSet().getVisibleColumns()) {
                    cells.put(col, this.m_scoutTable.getCell(scoutRow, col));
                }
                this.m_cachedCells.put(scoutRow, cells);
            }
        }
    }

    public RwtScoutTable getRwtScoutTable() {
        return this.m_uiTable;
    }
}

