/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table.celleditor;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.RwtScoutTableCellEditor;
import org.eclipse.scout.rt.ui.rap.form.fields.IPopupSupport;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class RwtScoutTableCellEditorEventHandler {
    private final RwtScoutTableCellEditor m_tableCellEditor;
    private final RwtScoutTable m_uiTableComposite;
    private final P_FocusLostListener m_focusLostListener;
    private final P_PopupListener m_popupListener;
    private final P_TraverseListener m_traverseListener;
    private RwtScoutTableCellEditor.RwtCellEditor m_cellEditor;
    private TraverseKey m_traverseKey = TraverseKey.NONE;

    public RwtScoutTableCellEditorEventHandler(RwtScoutTableCellEditor tableCellEditor, RwtScoutTable uiTableComposite) {
        this.m_tableCellEditor = tableCellEditor;
        this.m_uiTableComposite = uiTableComposite;
        this.m_focusLostListener = new P_FocusLostListener();
        this.m_popupListener = new P_PopupListener();
        this.m_traverseListener = new P_TraverseListener();
    }

    public void setupFocusAndTraverseListenerOnFocusControl(Control focusControl, RwtScoutTableCellEditor.RwtCellEditor cellEditor) {
        this.m_cellEditor = cellEditor;
        this.installFocusLostListenerOnFocusControl(focusControl);
        this.installTraverseListenerOnFocusControl(focusControl);
    }

    protected void installFocusLostListenerOnFocusControl(Control focusControl) {
        focusControl.addFocusListener((FocusListener)this.m_focusLostListener);
        this.m_focusLostListener.setFocusControl(focusControl);
    }

    protected void installTraverseListenerOnFocusControl(Control focusControl) {
        focusControl.addTraverseListener((TraverseListener)this.m_traverseListener);
    }

    public void installPopupListenerOnPopupSupport(IPopupSupport popupSupportFormField) {
        popupSupportFormField.addPopupEventListener(this.m_popupListener);
    }

    public void activateFocusLostListener() {
        this.m_focusLostListener.install();
    }

    public void deactivateFocusLostListener() {
        this.m_focusLostListener.uninstall();
    }

    public void deregisterKeyStrokeFromFocusControl() {
        Control focusControl = this.m_focusLostListener.getFocusControl();
        if (focusControl != null && !focusControl.isDisposed()) {
            this.m_uiTableComposite.getUiEnvironment().removeKeyStrokes(focusControl);
        }
    }

    public void suspendFocusLostListener() {
        this.m_focusLostListener.suspend();
    }

    public void resumeFocusLostListener() {
        this.m_focusLostListener.resume();
    }

    protected void setTraverseKey(Integer traverseKey) {
        this.m_traverseKey = traverseKey == 16 ? TraverseKey.TAB_NEXT : (traverseKey == 8 ? TraverseKey.TAB_PREVIOUS : TraverseKey.NONE);
    }

    protected TraverseKey getTraverseKey() {
        return this.m_traverseKey;
    }

    private class P_FocusLostListener
    extends FocusAdapter {
        private static final long serialVersionUID = 1L;
        private final Lock m_suspendLock = new ReentrantLock();
        private AtomicInteger m_suspendCounter = new AtomicInteger();
        private Control m_focusControl;

        private P_FocusLostListener() {
        }

        public void setFocusControl(Control focusControl) {
            this.m_focusControl = focusControl;
        }

        public Control getFocusControl() {
            return this.m_focusControl;
        }

        public void uninstall() {
            this.m_suspendCounter.set(0);
        }

        public void install() {
            this.m_suspendCounter.set(0);
        }

        public void resume() {
            this.m_suspendLock.lock();
            try {
                if (this.m_suspendCounter.decrementAndGet() < 0) {
                    this.m_suspendCounter.set(0);
                }
            }
            finally {
                this.m_suspendLock.unlock();
            }
        }

        public void suspend() {
            this.m_suspendLock.lock();
            try {
                this.m_suspendCounter.incrementAndGet();
            }
            finally {
                this.m_suspendLock.unlock();
            }
        }

        public boolean isSuspended() {
            return this.m_suspendCounter.get() > 0;
        }

        public void focusLost(FocusEvent event) {
            if (this.isSuspended()) {
                return;
            }
            Control currentFocus = RwtScoutTableCellEditorEventHandler.this.m_cellEditor.getControl().getDisplay().getFocusControl();
            if (currentFocus == null || currentFocus.isDisposed()) {
                return;
            }
            TableViewer viewer = RwtScoutTableCellEditorEventHandler.this.m_uiTableComposite.getUiTableViewer();
            if (!viewer.isCellEditorActive()) {
                return;
            }
            Control tableControl = RwtScoutTableCellEditorEventHandler.this.m_uiTableComposite.getUiTableViewer().getControl();
            if (!RwtUtility.isAncestorOf(tableControl, currentFocus)) {
                CellEditor[] cellEditorArray = viewer.getCellEditors();
                int n = cellEditorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CellEditor editor = cellEditorArray[n2];
                    if (editor != null && editor.isActivated() && editor instanceof RwtScoutTableCellEditor.RwtCellEditor) {
                        ((RwtScoutTableCellEditor.RwtCellEditor)editor).stopCellEditing();
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    private class P_PopupListener
    implements IPopupSupport.IPopupSupportListener {
        private boolean m_isPopUpOpen = false;

        private P_PopupListener() {
        }

        public boolean isPopUpOpen() {
            return this.m_isPopUpOpen;
        }

        @Override
        public void handleEvent(int eventType) {
            if (eventType == 2) {
                RwtScoutTableCellEditorEventHandler.this.m_focusLostListener.suspend();
                this.m_isPopUpOpen = true;
            } else if (eventType == 4) {
                RwtScoutTableCellEditorEventHandler.this.m_focusLostListener.resume();
                this.m_isPopUpOpen = false;
                this.handleTraverseTabKey();
            }
        }

        private void notifyFocusLostOnLastFocusControl() {
            Control focusControl = RwtScoutTableCellEditorEventHandler.this.m_focusLostListener.getFocusControl();
            Event focusEvent = new Event();
            focusEvent.widget = focusControl;
            focusControl.notifyListeners(16, focusEvent);
        }

        private void handleTraverseTabKey() {
            if (RwtScoutTableCellEditorEventHandler.this.getTraverseKey() == TraverseKey.NONE) {
                this.notifyFocusLostOnLastFocusControl();
                return;
            }
            ITableRow tableRow = RwtScoutTableCellEditorEventHandler.this.m_cellEditor.getScoutTableRow();
            IColumn<?> tableColumn = RwtScoutTableCellEditorEventHandler.this.m_cellEditor.getScoutTableColumn();
            this.notifyFocusLostOnLastFocusControl();
            if (RwtScoutTableCellEditorEventHandler.this.m_cellEditor.isActivated()) {
                RwtScoutTableCellEditorEventHandler.this.m_cellEditor.stopCellEditing();
            }
            if (tableRow != null && tableColumn != null) {
                RwtScoutTableCellEditorEventHandler.this.m_tableCellEditor.enqueueEditNextTableCell(tableRow, tableColumn, RwtScoutTableCellEditorEventHandler.this.getTraverseKey() == TraverseKey.TAB_NEXT);
            }
            RwtScoutTableCellEditorEventHandler.this.setTraverseKey(0);
        }
    }

    private class P_TraverseListener
    implements TraverseListener {
        private static final long serialVersionUID = 1L;

        private P_TraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            switch (e.detail) {
                case 2: 
                case 4: {
                    e.doit = false;
                    break;
                }
                case 16: {
                    this.handleTraverseEvent(e, 16, true);
                    break;
                }
                case 8: {
                    this.handleTraverseEvent(e, 8, false);
                }
            }
        }

        private void handleTraverseEvent(TraverseEvent event, Integer traverseKey, boolean forwardToNextCell) {
            event.doit = false;
            if (RwtScoutTableCellEditorEventHandler.this.m_popupListener.isPopUpOpen()) {
                RwtScoutTableCellEditorEventHandler.this.setTraverseKey(traverseKey);
            } else {
                this.verifyInputOnControlAndEditNextCell((Control)event.getSource(), forwardToNextCell);
            }
        }

        private void verifyInputOnControlAndEditNextCell(Control control, boolean forwardToNextCell) {
            RwtUtility.runUiInputVerifier(control);
            ITableRow scoutTableRow = RwtScoutTableCellEditorEventHandler.this.m_cellEditor.getScoutTableRow();
            IColumn<?> scoutTableColumn = RwtScoutTableCellEditorEventHandler.this.m_cellEditor.getScoutTableColumn();
            RwtScoutTableCellEditorEventHandler.this.m_cellEditor.stopCellEditing();
            RwtScoutTableCellEditorEventHandler.this.m_tableCellEditor.enqueueEditNextTableCell(scoutTableRow, scoutTableColumn, forwardToNextCell);
        }
    }

    static enum TraverseKey {
        TAB_NEXT,
        TAB_PREVIOUS,
        NONE;

    }
}

