/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext.tree;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeEx
extends Tree {
    private static final long serialVersionUID = 1L;
    private static final String BACKUPED_MENU = "backupedMenu";
    private boolean m_readOnly = false;
    private TreeItem m_contextItem;

    public TreeEx(Composite parent, int style) {
        super(parent, style | 0x10000);
        this.addListener(3, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                TreeEx.this.m_contextItem = TreeEx.this.getItem(new Point(event.x, event.y));
            }
        });
    }

    protected void checkSubclass() {
    }

    public TreeItem getContextItem() {
        return this.m_contextItem;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.m_readOnly != readOnly) {
            this.m_readOnly = readOnly;
            if (readOnly) {
                this.setData(BACKUPED_MENU, this.getMenu());
            } else {
                this.setMenu((Menu)this.getData(BACKUPED_MENU));
            }
        }
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public Point getPreferredContentSize(int maxRowCount, TreeItem parentItem, int stage) {
        Rectangle max = new Rectangle(0, 0, 0, 0);
        int nr = this.getItemCount();
        if (parentItem != null) {
            nr = parentItem.getItemCount();
        }
        int r = 0;
        while (r < nr && r < maxRowCount) {
            TreeItem item = parentItem == null ? this.getItem(r) : parentItem.getItem(r);
            if (item.getItemCount() > 0) {
                Point childSize = this.getPreferredContentSize(maxRowCount, item, stage + 1);
                Rectangle bounds = new Rectangle(0, 0, childSize.x, childSize.y);
                max = max.union(bounds);
            }
            Rectangle bounds = item.getBounds();
            String text = item.getText();
            if (!StringUtility.hasText((String)text) && item.getData() instanceof ITreeNode) {
                text = ((ITreeNode)item.getData()).getCell().getText();
            }
            if (StringUtility.hasText((String)text)) {
                int textWidth;
                bounds.width = textWidth = TextSizeUtil.stringExtent((Font)item.getFont(), (String)text).x;
            }
            bounds.width += stage * 5;
            max = max.union(bounds);
            ++r;
        }
        int y = max.y + max.height;
        y = nr > 3 ? ++y : (nr > 1 ? (y += 2) : (y += 4));
        return new Point(max.x + max.width, y);
    }
}

