/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.RwtShellValidateRoot;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.AbstractRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.DefaultFormBoundsProvider;
import org.eclipse.scout.rt.ui.rap.window.IFormBoundsProvider;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutFormFooter;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutFormHeader;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;

public class RwtScoutDialog
extends AbstractRwtScoutPart {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutDialog.class);
    private static String VARIANT_DIALOG_SHELL = "dialog";
    private DialogImpl m_uiDialog;
    private Point m_uiInitialLocation;
    private Point m_uiInitialSize;
    private IFormBoundsProvider m_boundsProvider;
    private Composite m_container;
    private IRwtScoutFormHeader m_formHeaderComposite;
    private Composite m_formBodyComposite;
    private IRwtScoutFormFooter m_formFooterComposite;

    protected void initInitialBounds(IFormBoundsProvider boundsProvider) {
        if (boundsProvider == null) {
            return;
        }
        Rectangle bounds = boundsProvider.getBounds();
        if (bounds != null) {
            if (bounds.x >= 0 || bounds.y >= 0) {
                this.setUiInitialLocation(new Point(bounds.x, bounds.y));
            }
            if (bounds.width >= 0 || bounds.height >= 0) {
                this.setUiInitialSize(new Point(bounds.width, bounds.height));
            }
        }
    }

    protected IFormBoundsProvider createFormBoundsProvider(IForm scoutForm, IRwtEnvironment uiEnvironment) {
        return new DefaultFormBoundsProvider(scoutForm, uiEnvironment);
    }

    @Override
    public void setBusy(boolean b) {
        if (this.getUiForm() != null) {
            this.getUiForm().setBusy(b);
            this.getUiForm().layout(true);
        }
    }

    @Override
    public Form getUiForm() {
        if (this.m_formBodyComposite instanceof Form) {
            return (Form)this.m_formBodyComposite;
        }
        return null;
    }

    @Override
    public Composite getUiContainer() {
        return this.m_container;
    }

    public void setUiInitialLocation(Point initialLocation) {
        this.m_uiInitialLocation = initialLocation;
    }

    public Point getUiInitialLocation() {
        return this.m_uiInitialLocation;
    }

    public Point getUiInitialSize() {
        return this.m_uiInitialSize;
    }

    public void setUiInitialSize(Point uiInitialSize) {
        this.m_uiInitialSize = uiInitialSize;
    }

    protected int getDialogStyle() {
        return 68720;
    }

    public void createPart(IForm scoutForm, Shell parentShell, IRwtEnvironment uiEnvironment) {
        this.createPart(scoutForm, parentShell, this.getDialogStyle(), uiEnvironment);
    }

    public void createPart(IForm scoutForm, Shell parentShell, int style, IRwtEnvironment uiEnvironment) {
        super.createPart(scoutForm, uiEnvironment);
        this.m_boundsProvider = this.createFormBoundsProvider(scoutForm, this.getUiEnvironment());
        this.initInitialBounds(this.m_boundsProvider);
        this.m_uiDialog = new DialogImpl((Shell)((style & 0x10000) != 0 ? parentShell : null), style);
        this.m_uiDialog.create();
        this.m_uiDialog.getShell().setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogShellVariant());
        DefaultValidateRoot shellValidateRoot = this.createShellValidateRoot(this.m_uiDialog.getShell(), this.getUiEnvironment());
        if (shellValidateRoot != null) {
            this.m_uiDialog.getShell().setData("LayoutValidateManager.validateRoot", (Object)shellValidateRoot);
        }
        this.m_uiDialog.getShell().addShellListener(new ShellListener(){
            private static final long serialVersionUID = 1L;

            public void shellDeactivated(ShellEvent e) {
                RwtScoutDialog.this.getUiEnvironment().invokeScoutLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutDialog.this.getScoutObject().toBack();
                    }
                }, 5432L);
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
                RwtScoutDialog.this.getUiEnvironment().invokeScoutLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutDialog.this.getScoutObject().toFront();
                    }
                }, 5432L);
            }
        });
    }

    private String getDialogShellVariant() {
        return VARIANT_DIALOG_SHELL;
    }

    public boolean isEclipseFormUsed() {
        return true;
    }

    private Composite createFormBody(Composite parent) {
        Composite body = null;
        Composite actualBody = null;
        if (this.isEclipseFormUsed()) {
            Form eclipseForm = this.getUiEnvironment().getFormToolkit().createForm(parent);
            body = eclipseForm;
            actualBody = eclipseForm.getBody();
        } else {
            actualBody = body = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        }
        actualBody.setLayout((Layout)new FillLayout());
        this.getUiEnvironment().createForm(actualBody, this.getScoutObject());
        return body;
    }

    protected Control createContentsDelegate(Composite parent) {
        this.m_uiDialog.getShell().addShellListener((ShellListener)new ShellAdapter(){
            private static final long serialVersionUID = 1L;

            public void shellActivated(ShellEvent e) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutDialog.this.getScoutObject().getUIFacade().fireFormActivatedFromUI();
                    }
                };
                RwtScoutDialog.this.getUiEnvironment().invokeScoutLater(job, 0L);
            }
        });
        this.m_container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.m_container.setLayoutData((Object)new GridData(1808));
        try {
            this.m_container.setRedraw(false);
            this.m_formHeaderComposite = this.getUiEnvironment().createFormHeader(this.m_container, this.getScoutObject());
            this.m_formBodyComposite = this.createFormBody(this.m_container);
            this.m_formFooterComposite = this.getUiEnvironment().createFormFooter(this.m_container, this.getScoutObject());
            this.initLayout(this.m_container);
            this.attachScout();
        }
        finally {
            this.m_container.setRedraw(true);
        }
        return this.m_container;
    }

    protected void initLayout(Composite container) {
        GridData gridData;
        GridLayout layout = RwtLayoutUtility.createGridLayoutNoSpacing(1, true);
        container.setLayout((Layout)layout);
        Composite header = null;
        if (this.m_formHeaderComposite != null) {
            header = this.m_formHeaderComposite.getUiContainer();
        }
        Composite body = this.m_formBodyComposite;
        Composite footer = null;
        if (this.m_formFooterComposite != null) {
            footer = this.m_formFooterComposite.getUiContainer();
        }
        if (header != null) {
            gridData = new GridData(768);
            if (this.getFormHeaderHeightHint() != null) {
                gridData.heightHint = this.getFormHeaderHeightHint();
            }
            header.setLayoutData((Object)gridData);
        }
        if (body != null) {
            gridData = new GridData(1808);
            body.setLayoutData((Object)gridData);
        }
        if (footer != null) {
            gridData = new GridData(768);
            if (this.getFormFooterHeightHint() != null) {
                gridData.heightHint = this.getFormFooterHeightHint();
            }
            footer.setLayoutData((Object)gridData);
        }
    }

    public Integer getFormHeaderHeightHint() {
        if (this.m_formHeaderComposite == null) {
            return null;
        }
        return this.m_formHeaderComposite.getHeightHint();
    }

    public Integer getFormFooterHeightHint() {
        if (this.m_formFooterComposite == null) {
            return null;
        }
        return this.m_formFooterComposite.getHeightHint();
    }

    @Override
    protected void showPartImpl() {
        this.m_uiDialog.setBlockOnOpen(false);
        this.m_uiDialog.open();
    }

    @Override
    protected void closePartImpl() {
        try {
            if (this.m_boundsProvider != null) {
                this.m_boundsProvider.storeBounds(this.m_uiDialog.getShell().getBounds());
            }
            this.detachScout();
        }
        finally {
            this.m_uiDialog.closePhysically();
        }
    }

    @Override
    protected void setImageFromScout() {
        String iconId = this.getScoutObject().getIconId();
        Image img = this.getUiEnvironment().getIcon(iconId);
        this.m_uiDialog.getShell().setImage(img);
        String sub = this.getScoutObject().getSubTitle();
        if (this.getUiForm() != null && !this.getUiForm().isDisposed()) {
            if (sub != null) {
                this.getUiForm().setImage(img);
            } else {
                this.getUiForm().setImage(null);
            }
        }
    }

    @Override
    protected void setTitleFromScout() {
        IForm f = this.getScoutObject();
        String s = f.getBasicTitle();
        this.m_uiDialog.getShell().setText(StringUtility.removeNewLines((String)(s != null ? s : "")));
        s = f.getSubTitle();
        if (this.getUiForm() != null && !this.getUiForm().isDisposed()) {
            if (s != null) {
                this.getUiForm().setText(RwtUtility.escapeMnemonics(StringUtility.removeNewLines((String)(s != null ? s : ""))));
            } else {
                this.getUiForm().setText(null);
            }
        }
    }

    @Override
    public void activate() {
        this.m_uiDialog.getShell().setActive();
    }

    @Override
    public boolean isActive() {
        return this.m_uiDialog.getShell() == this.getUiEnvironment().getDisplay().getActiveShell();
    }

    @Override
    public boolean isVisible() {
        return this.m_uiDialog.getShell().isVisible();
    }

    @Override
    public boolean setStatusLineMessage(Image image, String message) {
        return false;
    }

    protected Dialog getUiDialog() {
        return this.m_uiDialog;
    }

    protected IFormBoundsProvider getBoundsProvider() {
        return this.m_boundsProvider;
    }

    protected DefaultValidateRoot createShellValidateRoot(Shell shell, IRwtEnvironment env) {
        return new RwtShellValidateRoot(shell, env);
    }

    private class DialogImpl
    extends Dialog {
        private static final long serialVersionUID = 1L;

        public DialogImpl(Shell parentShell, int style) {
            super(parentShell);
            this.setShellStyle(style);
        }

        protected Control createContents(Composite parent) {
            return RwtScoutDialog.this.createContentsDelegate(parent);
        }

        protected final Control createButtonBar(Composite parent) {
            return null;
        }

        public boolean close() {
            Control focusControl = RwtScoutDialog.this.m_uiDialog.getShell().getDisplay().getFocusControl();
            RwtUtility.runUiInputVerifier(focusControl);
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    RwtScoutDialog.this.getScoutObject().getUIFacade().fireFormClosingFromUI();
                }
            };
            RwtScoutDialog.this.getUiEnvironment().invokeScoutLater(job, 0L);
            return false;
        }

        public boolean closePhysically() {
            return super.close();
        }

        protected Point getInitialLocation(Point initialSize) {
            if (RwtScoutDialog.this.m_uiInitialLocation != null) {
                return RwtScoutDialog.this.m_uiInitialLocation;
            }
            return super.getInitialLocation(initialSize);
        }

        protected Point getInitialSize() {
            if (RwtScoutDialog.this.m_uiInitialSize != null) {
                return RwtScoutDialog.this.m_uiInitialSize;
            }
            return super.getInitialSize();
        }
    }
}

