/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.service.internal.Activator;
import org.eclipse.scout.service.internal.ServicesExtensionManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class SERVICES {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SERVICES.class);

    private SERVICES() {
    }

    public static <T> T getService(Class<T> serviceInterfaceClass) {
        return SERVICES.getService(serviceInterfaceClass, null);
    }

    public static <T> T getService(Class<T> serviceInterfaceClass, String filter) {
        T service;
        Activator a = Activator.getDefault();
        if (a == null || serviceInterfaceClass == null) {
            return null;
        }
        ServicesExtensionManager extMgr = a.getServicesExtensionManager();
        extMgr.start();
        BundleContext context = a.getBundle().getBundleContext();
        if (context == null) {
            return null;
        }
        ServiceReference serviceReference = null;
        if (filter == null && (serviceReference = context.getServiceReference(serviceInterfaceClass.getName())) != null && (service = extMgr.fastResolveService(serviceInterfaceClass, context, serviceReference)) != null) {
            return service;
        }
        ServiceReference[] refs = null;
        try {
            refs = context.getAllServiceReferences(serviceInterfaceClass.getName(), filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                T service2 = extMgr.fastResolveService(serviceInterfaceClass, context, ref);
                if (service2 != null) {
                    return service2;
                }
                ++n2;
            }
        }
        return null;
    }

    public static <T> T[] getServices(Class<T> serviceInterfaceClass) {
        return SERVICES.getServices(serviceInterfaceClass, null);
    }

    public static <T> T[] getServices(Class<T> serviceInterfaceClass, String filter) {
        Activator a = Activator.getDefault();
        if (a == null || serviceInterfaceClass == null) {
            return (Object[])Array.newInstance(serviceInterfaceClass, 0);
        }
        ServicesExtensionManager extMgr = a.getServicesExtensionManager();
        extMgr.start();
        BundleContext context = a.getBundle().getBundleContext();
        if (context == null) {
            return (Object[])Array.newInstance(serviceInterfaceClass, 0);
        }
        ServiceReference[] refs = null;
        try {
            refs = context.getAllServiceReferences(serviceInterfaceClass.getName(), filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (refs != null) {
            Arrays.sort(refs, new Comparator<ServiceReference>(){

                @Override
                public int compare(ServiceReference ref1, ServiceReference ref2) {
                    return ((Comparable)ref2.getProperty("service.ranking")).compareTo((Comparable)ref1.getProperty("service.ranking"));
                }
            });
            ArrayList<T> list = new ArrayList<T>(refs.length);
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                T s = extMgr.fastResolveService(serviceInterfaceClass, context, ref);
                if (s != null) {
                    list.add(s);
                }
                ++n2;
            }
            return list.toArray((Object[])Array.newInstance(serviceInterfaceClass, list.size()));
        }
        return (Object[])Array.newInstance(serviceInterfaceClass, 0);
    }

    public static void clearCache() {
        Activator a = Activator.getDefault();
        if (a == null) {
            return;
        }
        ServicesExtensionManager extMgr = a.getServicesExtensionManager();
        extMgr.clearDirectAccessorCache();
    }
}

