/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import org.eclipse.scout.commons.CompareUtility;

public final class Assertions {
    private Assertions() {
    }

    public static <T> T assertNull(T value) {
        return Assertions.assertNull(value, "expected 'null' object but was 'non-null'", new Object[0]);
    }

    public static <T> T assertNull(T value, String msg, Object ... msgArgs) {
        if (value != null) {
            Assertions.fail(msg, msgArgs);
        }
        return value;
    }

    public static <T> T assertNotNull(T value) {
        return Assertions.assertNotNull(value, "expected 'non-null' object but was 'null'", new Object[0]);
    }

    public static <T> T assertNotNull(T value, String msg, Object ... msgArgs) {
        if (value == null) {
            Assertions.fail(msg, msgArgs);
        }
        return value;
    }

    public static String assertNotNullOrEmpty(String value) {
        if (value == null) {
            Assertions.fail("expected 'non-null' String but was 'null'.", new Object[0]);
        } else if (value.isEmpty()) {
            Assertions.fail("expected 'non-empty' String but was 'empty'.", new Object[0]);
        }
        return value;
    }

    public static String assertNotNullOrEmpty(String value, String msg, Object ... msgArgs) {
        if (value == null || value.isEmpty()) {
            Assertions.fail(msg, msgArgs);
        }
        return value;
    }

    public static boolean assertTrue(boolean value) {
        return Assertions.assertTrue(value, "expected 'true' but was 'false'.", new Object[0]);
    }

    public static boolean assertTrue(boolean value, String msg, Object ... msgArgs) {
        if (!value) {
            Assertions.fail(msg, msgArgs);
        }
        return value;
    }

    public static boolean assertFalse(boolean value) {
        return Assertions.assertFalse(value, "expected 'false' but was 'true'.", new Object[0]);
    }

    public static boolean assertFalse(boolean value, String msg, Object ... msgArgs) {
        if (value) {
            Assertions.fail(msg, msgArgs);
        }
        return value;
    }

    public static <T> T assertEquals(T value1, Object value2) {
        return Assertions.assertEquals(value1, value2, "expected value1 to be equals with value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T> T assertEquals(T value1, Object value2, String msg, Object ... msgArgs) {
        if (!CompareUtility.equals(value1, value2)) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T> T assertNotEquals(T value1, Object value2) {
        return Assertions.assertNotEquals(value1, value2, "expected value1 to be equals with value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T> T assertNotEquals(T value1, Object value2, String msg, Object ... msgArgs) {
        if (CompareUtility.equals(value1, value2)) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T> T assertSame(T value1, Object value2) {
        return Assertions.assertSame(value1, value2, "expected value1 to be equals with value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T> T assertSame(T value1, Object value2, String msg, Object ... msgArgs) {
        if (value1 != value2) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T> T assertNotSame(T value1, Object value2) {
        return Assertions.assertNotSame(value1, value2, "expected value1 to be equals with value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T> T assertNotSame(T value1, Object value2, String msg, Object ... msgArgs) {
        if (value1 == value2) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T extends Comparable<T>> T assertEqual(T value1, T value2) {
        return Assertions.assertEqual(value1, value2, "expected value1 to be equals with value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T extends Comparable<T>> T assertEqual(T value1, T value2, String msg, Object ... msgArgs) {
        if (value1.compareTo(value2) != 0) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T extends Comparable<T>> T assertGreater(T value1, T value2) {
        return Assertions.assertGreater(value1, value2, "expected value1 to be '>' value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T extends Comparable<T>> T assertGreater(T value1, T value2, String msg, Object ... msgArgs) {
        if (value1.compareTo(value2) <= 0) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T extends Comparable<T>> T assertGreaterOrEqual(T value1, T value2) {
        return Assertions.assertGreaterOrEqual(value1, value2, "expected value1 to be '>=' value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T extends Comparable<T>> T assertGreaterOrEqual(T value1, T value2, String msg, Object ... msgArgs) {
        if (value1.compareTo(value2) < 0) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T extends Comparable<T>> T assertLess(T value1, T value2) {
        return Assertions.assertLess(value1, value2, "expected value1 to be '<' value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T extends Comparable<T>> T assertLess(T value1, T value2, String msg, Object ... msgArgs) {
        if (value1.compareTo(value2) >= 0) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T extends Comparable<T>> T assertLessOrEqual(T value1, T value2) {
        return Assertions.assertLessOrEqual(value1, value2, "expected value1 to be '<=' value2 [value1=%s, value2=%s]", value1, value2);
    }

    public static <T extends Comparable<T>> T assertLessOrEqual(T value1, T value2, String msg, Object ... msgArgs) {
        if (value1.compareTo(value2) > 0) {
            Assertions.fail(msg, msgArgs);
        }
        return value1;
    }

    public static <T> T fail(String msg, Object ... msgArgs) {
        String message = msg != null ? String.format(msg, msgArgs) : "n/a";
        throw new AssertionException(String.format("Assertion error: %s", message), new Object[0]);
    }

    public static class AssertionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AssertionException(String msg, Object ... msgArgs) {
            super(String.format(msg, msgArgs));
        }
    }
}

