/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.eventlistprofiler;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.eventlistprofiler.EventListenerSnapshot;
import org.eclipse.scout.commons.eventlistprofiler.IEventListenerSource;

public final class EventListenerProfiler {
    private static EventListenerProfiler instance = new EventListenerProfiler();
    private boolean m_enabled = false;
    private Object m_sourcesLock = new Object();
    private List<WeakReference<IEventListenerSource>> m_sources = new ArrayList<WeakReference<IEventListenerSource>>();

    public static EventListenerProfiler getInstance() {
        return instance;
    }

    private EventListenerProfiler() {
        this.m_sourcesLock = new Object();
        this.m_sources = new ArrayList<WeakReference<IEventListenerSource>>();
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSourceAsWeakReference(IEventListenerSource source) {
        if (!this.m_enabled) {
            return;
        }
        Object object = this.m_sourcesLock;
        synchronized (object) {
            this.m_sources.add(new WeakReference<IEventListenerSource>(source));
        }
    }

    public void dump() {
        this.dump(System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(OutputStream o) {
        System.gc();
        PrintWriter out = new PrintWriter(o, true);
        if (!this.m_enabled) {
            return;
        }
        try {
            try {
                EventListenerSnapshot snapshot = new EventListenerSnapshot();
                Object object = this.m_sourcesLock;
                synchronized (object) {
                    this.manageNoLock();
                    NumberFormat fmt = NumberFormat.getIntegerInstance(LocaleThreadLocal.get());
                    out.println("Max memory:   " + fmt.format(Runtime.getRuntime().maxMemory()));
                    out.println("Total memory: " + fmt.format(Runtime.getRuntime().totalMemory()));
                    out.println("Free memory:  " + fmt.format(Runtime.getRuntime().freeMemory()));
                    out.println("(Used memory):" + fmt.format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                    out.println();
                    for (WeakReference<IEventListenerSource> ref : this.m_sources) {
                        IEventListenerSource p = (IEventListenerSource)ref.get();
                        if (p == null) continue;
                        p.dumpListenerList(snapshot);
                    }
                }
                snapshot.dump(out);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (o != System.out) {
                    out.close();
                }
            }
        }
        finally {
            if (o != System.out) {
                out.close();
            }
        }
    }

    private void manageNoLock() {
        Iterator<WeakReference<IEventListenerSource>> it = this.m_sources.iterator();
        while (it.hasNext()) {
            WeakReference<IEventListenerSource> ref = it.next();
            if (ref.get() != null) continue;
            it.remove();
        }
    }
}

