/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.html.IHtmlBind;
import org.eclipse.scout.commons.html.IHtmlContent;
import org.eclipse.scout.commons.html.internal.HtmlBind;

public class HtmlBinds {
    private final Map<String, Object> m_bindMap = new HashMap<String, Object>();
    private final String m_prefix = ":b__";
    private long m_sequenceId = 0L;

    public IHtmlBind putString(String value) {
        String qualifiedName = this.nextBindName();
        this.m_bindMap.put(qualifiedName, value);
        return new HtmlBind(qualifiedName);
    }

    public IHtmlBind put(Object value) {
        return this.putString(StringUtility.nvl(value, ""));
    }

    protected String nextBindName() {
        String name = this.getBindName(this.m_sequenceId);
        ++this.m_sequenceId;
        return name;
    }

    private String getBindName(long sequenceNr) {
        return ":b__" + sequenceNr;
    }

    public Object getBindValue(String key) {
        return this.m_bindMap.get(key);
    }

    protected String getPrefix() {
        return ":b__";
    }

    public Map<String, Object> getBindMap() {
        return CollectionUtility.copyMap(this.m_bindMap);
    }

    public void putAll(HtmlBinds binds) {
        for (Map.Entry<String, Object> entry : binds.getBindMap().entrySet()) {
            String key = entry.getKey();
            long seq = this.getSequenceId(key);
            if (this.m_bindMap.containsKey(key)) continue;
            this.m_bindMap.put(key, entry.getValue());
            if (this.m_sequenceId > seq) continue;
            this.m_sequenceId = seq + 1L;
        }
    }

    private long getSequenceId(String key) {
        String seq = key.substring(":b__".length());
        return Long.parseLong(seq);
    }

    public Map<String, String> getReplacements(HtmlBinds binds) {
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        Map<String, Object> bindMap = binds.getBindMap();
        ArrayList<String> keys = new ArrayList<String>(bindMap.keySet());
        Collections.sort(keys, new BindIdComparator());
        for (String existingBind : keys) {
            if (!this.m_bindMap.containsKey(existingBind)) continue;
            String newBind = this.nextBindName();
            this.m_bindMap.put(newBind, bindMap.get(existingBind));
            replaceMap.put(existingBind, newBind);
        }
        return replaceMap;
    }

    @Deprecated
    public String applyBindParameters(IHtmlContent ... htmls) {
        return this.applyBindParameters(Arrays.asList(htmls));
    }

    @Deprecated
    public String applyBindParameters(List<? extends IHtmlContent> htmls) {
        StringBuilder sb = new StringBuilder();
        for (IHtmlContent iHtmlContent : htmls) {
            iHtmlContent.setBinds(this);
            sb.append(iHtmlContent.toEncodedHtml());
        }
        return sb.toString();
    }

    public List<String> getBindParameters(CharSequence s) {
        ArrayList<String> binds = new ArrayList<String>();
        Pattern p = Pattern.compile(String.valueOf(this.getPrefix()) + "(\\d+)", 8);
        Matcher m = p.matcher(s);
        while (m.find()) {
            binds.add(m.group(0));
        }
        return binds;
    }

    public String toString() {
        return "HtmlBinds [m_bindMap=" + this.m_bindMap + "]";
    }

    public void replaceBinds(Map<String, String> bindMap) {
        for (Map.Entry<String, String> entry : bindMap.entrySet()) {
            this.m_bindMap.put(entry.getValue(), this.m_bindMap.get(entry.getKey()));
            this.m_bindMap.remove(entry.getKey());
        }
    }

    class BindIdComparator
    implements Comparator<String> {
        BindIdComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return (int)(Long.parseLong(o1.substring(HtmlBinds.this.getPrefix().length())) - Long.parseLong(o2.substring(HtmlBinds.this.getPrefix().length())));
        }
    }
}

