/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.html.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.html.IHtmlElement;
import org.eclipse.scout.commons.html.internal.HtmlContentBuilder;

public class HtmlNodeBuilder
extends HtmlContentBuilder
implements IHtmlElement {
    private final List<String> m_attributes = new ArrayList<String>();
    private String m_tag;

    protected String getTag() {
        return this.m_tag;
    }

    public HtmlNodeBuilder(String tag, CharSequence ... texts) {
        this(tag, Arrays.asList(texts));
    }

    public HtmlNodeBuilder(String tag) {
        this(tag, new ArrayList());
    }

    public HtmlNodeBuilder(String tag, List<? extends CharSequence> texts) {
        super(texts);
        this.m_tag = tag;
    }

    @Override
    public void build() {
        this.appendStartTag();
        if (this.getTexts().size() > 0) {
            this.appendText();
        }
        this.appendEndTag();
    }

    protected void appendStartTag() {
        this.append("<");
        this.append(this.getTag());
        this.appendAttributes();
        this.append(">");
    }

    protected void appendEndTag() {
        this.append("</");
        this.append(this.getTag());
        this.append(">");
    }

    private void appendAttributes() {
        if (this.m_attributes.size() > 0) {
            this.append(" ");
            this.append(CollectionUtility.format(this.m_attributes, " "));
        }
    }

    protected void addAttribute(String name, int value) {
        this.addAttribute(name, Integer.toString(value));
    }

    @Override
    public IHtmlElement addAttribute(String name, CharSequence value) {
        this.m_attributes.add(String.valueOf(name) + "=\"" + value + "\"");
        return this;
    }

    @Override
    public void replaceBinds(Map<String, String> bindMap) {
        super.replaceBinds(bindMap);
        this.getBinds().replaceBinds(bindMap);
    }

    @Override
    public IHtmlElement style(CharSequence value) {
        this.addAttribute("style", value);
        return this;
    }

    @Override
    public IHtmlElement cssClass(CharSequence cssClass) {
        this.addAttribute("class", cssClass);
        return this;
    }

    @Override
    public IHtmlElement appLink(CharSequence ref) {
        this.cssClass("app-link");
        this.addAttribute("data-ref", ref);
        return this;
    }
}

