/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.html.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.commons.html.IHtmlContent;
import org.eclipse.scout.commons.html.internal.AbstractExpressionBuilder;

public class HtmlPlainBuilder
extends AbstractExpressionBuilder {
    private final List<? extends CharSequence> m_texts;

    public HtmlPlainBuilder(CharSequence ... texts) {
        this(Arrays.asList(texts));
    }

    public HtmlPlainBuilder(List<? extends CharSequence> texts) {
        this.m_texts = this.importTexts(texts);
    }

    protected ArrayList<? extends CharSequence> importTexts(List<? extends CharSequence> texts) {
        ArrayList<CharSequence> bindTexts = new ArrayList<CharSequence>();
        for (CharSequence charSequence : texts) {
            if (charSequence == null) continue;
            if (charSequence instanceof IHtmlContent) {
                bindTexts.add(this.importHtml((IHtmlContent)charSequence));
                continue;
            }
            bindTexts.add(charSequence);
        }
        return bindTexts;
    }

    @Override
    public void build() {
        if (this.m_texts.size() > 0) {
            this.appendText();
        }
    }

    protected void appendText() {
        for (CharSequence charSequence : this.m_texts) {
            this.append(charSequence);
        }
    }
}

