/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal;

import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.resources.WsservletMessages;
import com.sun.xml.internal.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.internal.ws.transport.http.ResourceLoader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.handler.Handler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.UriBuilder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.Activator;
import org.eclipse.scout.jaxws.handler.internal.IScoutTransactionHandlerWrapper;
import org.eclipse.scout.jaxws.internal.resources.BundleProxyClassLoader;
import org.eclipse.scout.jaxws.internal.resources.BundleProxyResourceLoader;
import org.eclipse.scout.jaxws.internal.resources.SunJaxWsXml;
import org.eclipse.scout.jaxws.internal.resources.SunJaxWsXmlFinder;
import org.eclipse.scout.jaxws.internal.servlet.JaxWsHelper;
import org.eclipse.scout.jaxws.internal.servlet.ServletAdapter;
import org.eclipse.scout.jaxws.internal.servlet.ServletAdapterFactory;
import org.eclipse.scout.jaxws.internal.servlet.ServletContainer;
import org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler;
import org.eclipse.scout.jaxws.service.IJaxWsEndpointService;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class JaxWsEndpointService
extends AbstractService
implements IJaxWsEndpointService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(JaxWsEndpointService.class);
    public static final String HTML_STATUS_PAGE_TEMPLATE = "jaxws-services.html";
    public static final String HTML_STATUS_PAGE_ENDPOINT_PLACEHOLDER = "#jaxws-services#";
    private ServletAdapter[] m_servletAdapters;
    private String m_propResourceBundle;
    private String m_propResourcePath;

    public final void initializeService(ServiceRegistration registration) {
        this.m_servletAdapters = this.createEndpointAdapters();
        this.initResourceBundle();
    }

    @Override
    public ServletAdapter[] getServletAdapters() {
        return this.m_servletAdapters;
    }

    @Override
    public ServletAdapter getServletAdapter(String alias) {
        if (alias == null) {
            return null;
        }
        ServletAdapter[] servletAdapterArray = this.m_servletAdapters;
        int n = this.m_servletAdapters.length;
        int n2 = 0;
        while (n2 < n) {
            ServletAdapter adapter = servletAdapterArray[n2];
            if (alias.equals(adapter.getAlias())) {
                return adapter;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getAuthenticationMethod(ServletAdapter adapter) {
        List handlers = adapter.getEndpoint().getBinding().getHandlerChain();
        for (Handler handler : handlers) {
            if (handler instanceof IScoutTransactionHandlerWrapper) {
                handler = ((IScoutTransactionHandlerWrapper)handler).getHandler();
            }
            if (!(handler instanceof IAuthenticationHandler)) continue;
            return ((IAuthenticationHandler)handler).getName();
        }
        return "None";
    }

    @Override
    public final void onGetRequest(HttpServletRequest request, HttpServletResponse response, ServletAdapter[] servletAdapters) throws Exception {
        String contentType;
        String pathInfo = request.getPathInfo();
        if (!StringUtility.hasText((String)pathInfo)) {
            response.setStatus(301);
            String baseUrl = JaxWsHelper.getBaseAddress(request, false);
            IPath contextPath = new Path(request.getRequestURI()).addTrailingSeparator().makeAbsolute();
            if (contextPath.isUNC()) {
                contextPath = contextPath.makeUNC(false);
            }
            URI redirectUri = new UriBuilder(baseUrl).path(contextPath.toString()).createURI();
            response.setHeader("Location", redirectUri.toString());
            return;
        }
        if (pathInfo == null || pathInfo.endsWith("/") || pathInfo.equals("")) {
            pathInfo = "/jaxws-services.html";
        }
        byte[] content = new byte[]{};
        if (new Path(pathInfo).lastSegment().equals(HTML_STATUS_PAGE_TEMPLATE)) {
            String html = this.createHtmlStatusPage(request.getContextPath(), servletAdapters);
            if (html != null) {
                content = html.getBytes("UTF-8");
            }
        } else {
            URL url = this.resolveResourceURL(pathInfo);
            if (url != null) {
                content = IOUtility.getContent((InputStream)url.openStream(), (boolean)true);
            } else {
                response.sendError(404);
                return;
            }
        }
        if ((contentType = FileUtility.getContentTypeForExtension((String)new Path(pathInfo).getFileExtension())) == null) {
            contentType = "application/unknown";
        }
        response.setContentType(contentType);
        response.setContentLength(content.length);
        response.setStatus(200);
        response.getOutputStream().write(content);
    }

    protected String createHtmlStatusPage(String contextPath, ServletAdapter[] servletAdapters) throws Exception {
        URL url = this.resolveResourceURL(HTML_STATUS_PAGE_TEMPLATE);
        if (url == null) {
            return null;
        }
        String html = IOUtility.getContent((Reader)new InputStreamReader(url.openStream()), (boolean)true);
        if (!html.contains(HTML_STATUS_PAGE_ENDPOINT_PLACEHOLDER)) {
            return html;
        }
        ArrayList<ServletAdapter> adaptersOrdered = new ArrayList<ServletAdapter>(Arrays.asList(servletAdapters));
        Collections.sort(adaptersOrdered, new Comparator<ServletAdapter>(){

            @Override
            public int compare(ServletAdapter adapter1, ServletAdapter adapter2) {
                return CompareUtility.compareTo((Comparable)((Object)adapter1.getAlias()), (Comparable)((Object)adapter2.getAlias()));
            }
        });
        StringBuilder builder = new StringBuilder();
        for (ServletAdapter adapter : adaptersOrdered) {
            String endpointAddress = adapter.getAddress(contextPath).toString();
            builder.append("<table class=\"service_box\" cellpadding=\"0\" cellspacing=\"0\">");
            builder.append("<tr><td colspan=\"2\" class=\"service_name\">" + StringUtility.nvl((Object)adapter.getAlias(), (String)"?") + "</td></tr>");
            builder.append("<tr><td class=\"left_content_box\">");
            builder.append("<table class=\"content_box\" cellpadding=\"0\" cellspacing=\"0\">");
            builder.append("<tr><td class=\"label\">Service Name:</td><td class=\"content\">" + adapter.getEndpoint().getServiceName() + "</td></tr>");
            builder.append("<tr><td class=\"label\">Port Name:</td><td class=\"content\">" + adapter.getEndpoint().getPortName() + "</td></tr>");
            builder.append("<tr><td class=\"label\">Authentication:</td><td class=\"content\">" + this.getAuthenticationMethod(adapter) + "</td></tr>");
            builder.append("</table>");
            builder.append("</td><td class=\"right_content_box\">");
            builder.append("<table class=\"content_box\" cellpadding=\"0\" cellspacing=\"0\">");
            builder.append("<tr><td class=\"label\">Address:</td><td class=\"content\">" + endpointAddress + "</td></tr>");
            builder.append("<tr><td class=\"label\">WSDL:</td><td class=\"content\"><a href=\"" + endpointAddress + "?wsdl\">" + endpointAddress + "?wsdl</a></td></tr>");
            builder.append("</table>");
            builder.append("</td></tr>");
            builder.append("</table>");
        }
        return html.replaceFirst(HTML_STATUS_PAGE_ENDPOINT_PLACEHOLDER, builder.toString());
    }

    public void disposeServices() {
        ServletAdapter[] servletAdapterArray = this.m_servletAdapters;
        int n = this.m_servletAdapters.length;
        int n2 = 0;
        while (n2 < n) {
            ServletAdapter servletAdapter = servletAdapterArray[n2];
            try {
                servletAdapter.getEndpoint().dispose();
            }
            catch (Throwable t) {
                LOG.error("failed to dispose webservice endpoint", t);
            }
            ++n2;
        }
    }

    protected ServletAdapter[] createEndpointAdapters() {
        ArrayList servletAdapters = new ArrayList();
        for (SunJaxWsXml cfg : new SunJaxWsXmlFinder().findAll()) {
            try {
                URL sunJaxWsXml = cfg.getResource();
                BundleProxyClassLoader classLoader = new BundleProxyClassLoader(cfg.getBundle());
                ClassLoader oldContextCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    BundleProxyResourceLoader resourceLoader = new BundleProxyResourceLoader(cfg.getBundle());
                    Container container = this.createContainer(resourceLoader);
                    DeploymentDescriptorParser.AdapterFactory<ServletAdapter> adapterFactory = this.createServletAdapterFactory();
                    DeploymentDescriptorParser<ServletAdapter> parser = this.createDeploymentDescriptorParser(classLoader, resourceLoader, container, adapterFactory);
                    List adaptersInBundle = parser.parse(sunJaxWsXml.toExternalForm(), sunJaxWsXml.openStream());
                    if (adaptersInBundle == null) continue;
                    servletAdapters.addAll(adaptersInBundle);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldContextCL);
                }
            }
            catch (Exception e) {
                LOG.error(String.valueOf(WsservletMessages.LISTENER_PARSING_FAILED((Object)e)) + " for bundle '" + cfg.getBundle().getSymbolicName() + "'", (Throwable)e);
            }
        }
        return servletAdapters.toArray(new ServletAdapter[servletAdapters.size()]);
    }

    protected DeploymentDescriptorParser<ServletAdapter> createDeploymentDescriptorParser(ClassLoader classLoader, ResourceLoader resourceLoader, Container container, DeploymentDescriptorParser.AdapterFactory adapterFactory) throws MalformedURLException {
        return new DeploymentDescriptorParser(classLoader, resourceLoader, container, adapterFactory);
    }

    protected Container createContainer(ResourceLoader resourceLoader) {
        return new ServletContainer((com.sun.xml.internal.ws.api.ResourceLoader)Platform.getAdapterManager().getAdapter((Object)resourceLoader, com.sun.xml.internal.ws.api.ResourceLoader.class));
    }

    protected DeploymentDescriptorParser.AdapterFactory<ServletAdapter> createServletAdapterFactory() {
        return new ServletAdapterFactory();
    }

    protected URL resolveResourceURL(String pathInfo) {
        if (this.m_propResourceBundle == null || this.m_propResourcePath == null) {
            return this.resolveDefaultResourceURL(pathInfo);
        }
        Bundle resourceBundle = Platform.getBundle((String)this.m_propResourceBundle);
        if (resourceBundle == null) {
            LOG.warn("The resource bundle configured in config-ini could not be found [property='org.eclipse.scout.jaxws.resource.bundle-name']");
            return this.resolveDefaultResourceURL(pathInfo);
        }
        URL url = resourceBundle.getResource(new Path(this.m_propResourcePath).append(pathInfo).toPortableString());
        if (url == null) {
            return this.resolveDefaultResourceURL(pathInfo);
        }
        return url;
    }

    private void initResourceBundle() {
        this.m_propResourceBundle = Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.jaxws.resource.bundle-name");
        if (!StringUtility.hasText((String)this.m_propResourceBundle)) {
            this.m_propResourceBundle = null;
        }
        this.m_propResourcePath = Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.jaxws.resource.bundle-path");
        if (!StringUtility.hasText((String)this.m_propResourcePath)) {
            this.m_propResourcePath = null;
        }
    }

    private URL resolveDefaultResourceURL(String pathInfo) {
        return Activator.getDefault().getBundle().getResource(new Path("/resources/html/").append(pathInfo).toPortableString());
    }
}

