/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.servlet;

import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.jaxws.internal.servlet.JaxWsHelper;
import org.eclipse.scout.jaxws.internal.servlet.ServletContextDelegate;

public class ServletConnection
extends WSHTTPConnection {
    private static final PropertySet.PropertyMap PROP_MODEL = ServletConnection.parse(ServletConnection.class);
    private final HttpServletRequest m_request;
    private final HttpServletResponse m_response;
    private final ServletContext m_context;
    private final WebServiceContextDelegate m_contextDelegate;
    private int m_status;
    private final Map<String, List<String>> m_responseHeaderMap;

    public ServletConnection(HttpAdapter adapter, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.m_context = context;
        this.m_request = request;
        this.m_response = response;
        this.m_contextDelegate = this.createContextDelegate(adapter, request);
        this.m_responseHeaderMap = new HashMap<String, List<String>>();
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.response"})
    public HttpServletResponse getResponse() {
        return this.m_response;
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.request"})
    public HttpServletRequest getRequest() {
        return this.m_request;
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.transport.http.servlet.requestURL"})
    public String getRequestURL() {
        return this.m_request.getRequestURL().toString();
    }

    public void setStatus(int status) {
        this.m_status = status;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.code"})
    public int getStatus() {
        return this.m_status;
    }

    public boolean isSecure() {
        return this.m_request.getScheme().equals("https");
    }

    public InputStream getInput() throws IOException {
        return this.m_request.getInputStream();
    }

    public String getProtocol() {
        return this.m_request.getProtocol();
    }

    public OutputStream getOutput() throws IOException {
        this.m_response.setStatus(this.m_status);
        return this.m_response.getOutputStream();
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.pathinfo"})
    public String getPathInfo() {
        return this.m_request.getPathInfo();
    }

    public String getBaseAddress() {
        return JaxWsHelper.getBaseAddress(this.m_request, true);
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.querystring"})
    public String getQueryString() {
        return this.m_request.getQueryString();
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.method"})
    public String getRequestMethod() {
        return this.m_request.getMethod();
    }

    public String getRequestHeader(String headerName) {
        return this.m_request.getHeader(headerName);
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.headers", "com.sun.xml.internal.ws.api.message.packet.inbound.transport.headers"})
    public Map<String, List<String>> getRequestHeaders() {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        Enumeration headerNames = this.m_request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = this.m_request.getHeader(name);
            if (headerMap.get(name) == null) {
                headerMap.put(name, new ArrayList());
            }
            ((List)headerMap.get(name)).add(value);
        }
        return headerMap;
    }

    public void setResponseHeaders(Map<String, List<String>> responseHeaders) {
        this.m_responseHeaderMap.clear();
        this.m_response.reset();
        this.m_response.setStatus(this.m_status);
        if (responseHeaders == null || responseHeaders.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            if (name.equalsIgnoreCase("Content-Type") || name.equalsIgnoreCase("Content-Length")) continue;
            for (String value : values) {
                this.m_response.addHeader(name, value);
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.headers", "com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers"})
    public Map<String, List<String>> getResponseHeaders() {
        return JaxWsHelper.cloneHeaderMap(this.m_responseHeaderMap);
    }

    public void setContentTypeResponseHeader(String value) {
        this.m_response.setContentType(value);
    }

    public void setContentLengthResponseHeader(int value) {
        this.m_response.setContentLength(value);
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.context"})
    public ServletContext getContext() {
        return this.m_context;
    }

    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this.m_contextDelegate;
    }

    protected PropertySet.PropertyMap getPropertyMap() {
        return PROP_MODEL;
    }

    protected WebServiceContextDelegate createContextDelegate(HttpAdapter adapter, HttpServletRequest request) {
        return new ServletContextDelegate(adapter, request);
    }
}

