/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.session;

import java.security.AccessController;
import javax.security.auth.Subject;
import javax.xml.ws.WebServiceException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;
import org.eclipse.scout.jaxws.session.ServerSessionClassFinder;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.service.SERVICES;

public class DefaultServerSessionFactory
implements IServerSessionFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultServerSessionFactory.class);
    public static final String PROP_SN_BUNDLE = String.valueOf(DefaultServerSessionFactory.class.getName()) + "#snBundle";
    public static final String PROP_QN_SESSION = String.valueOf(DefaultServerSessionFactory.class.getName()) + "#qnSession";

    @Override
    public IServerSession create() {
        Class<? extends IServerSession> sessionClazz = ServerSessionClassFinder.find();
        if (sessionClazz == null) {
            throw new WebServiceException("Server session class could not be found.'");
        }
        Subject subject = null;
        try {
            subject = Subject.getSubject(AccessController.getContext());
        }
        catch (Exception e) {
            LOG.error("Failed to get subject of calling acess context", (Throwable)e);
        }
        if (subject == null) {
            throw new WebServiceException("Unexpected: missing subject in current access context.");
        }
        try {
            return ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(sessionClazz, subject);
        }
        catch (Throwable e) {
            if (e.getCause() instanceof SecurityException) {
                throw new WebServiceException("Session could not be created. Access denied.", e);
            }
            throw new WebServiceException("Session could not be created.", e);
        }
    }
}

