/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.services.operation;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.simple.operations.CreateSimpleNlsProjectOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.operation.service.ServiceRegistrationDescription;
import org.eclipse.scout.sdk.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.method.MethodBodySourceBuilderFactory;
import org.eclipse.scout.sdk.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;

public class CreateServiceNlsProjectOperation
implements IOperation {
    private final String m_serviceName;
    private final String m_packageName;
    private final IJavaProject m_javaProject;
    private IType m_superType;
    private String m_translationFolder;
    private String m_translationFilePrefix;
    private String[] m_languages;
    private IType m_createdServiceType;

    public CreateServiceNlsProjectOperation(String serviceName, String packagename, IJavaProject javaProject) {
        this.m_serviceName = serviceName;
        this.m_packageName = packagename;
        this.m_javaProject = javaProject;
    }

    public String getOperationName() {
        return "Create new NLS Service Project...";
    }

    public void validate() throws IllegalArgumentException {
        if (this.m_superType == null) {
            throw new IllegalArgumentException("super type not set.");
        }
        if (this.m_javaProject == null) {
            throw new IllegalArgumentException("bundle not set.");
        }
        if (StringUtility.isNullOrEmpty((String)this.getTranslationFolder())) {
            throw new IllegalArgumentException("translation folder not set.");
        }
        if (StringUtility.isNullOrEmpty((String)this.getTranslationFilePrefix())) {
            throw new IllegalArgumentException("translation file prefix not set.");
        }
        if (StringUtility.isNullOrEmpty((String)this.getServiceName())) {
            throw new IllegalArgumentException("service name not set.");
        }
        if (this.m_languages == null || this.m_languages.length < 1) {
            throw new IllegalArgumentException("no languages set.");
        }
    }

    private void createLanguageFiles(IProgressMonitor monitor) throws CoreException {
        IFolder folder = this.getJavaProject().getProject().getFolder(this.getTranslationFolder());
        String[] stringArray = this.getLanguages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            CreateSimpleNlsProjectOperation.createLanguageFile((String)lang, (IFolder)folder, (String)this.getTranslationFilePrefix(), (IProgressMonitor)monitor);
            ++n2;
        }
    }

    private void addBuildEntry() throws CoreException {
        IFolder folder = this.getJavaProject().getProject().getFolder(this.getTranslationFolder());
        PluginModelHelper pmh = new PluginModelHelper(this.getJavaProject().getProject());
        IFolder checkFolder = folder;
        while (this.getJavaProject().getProject().getLocation().isPrefixOf(checkFolder.getLocation())) {
            if (pmh.BuildProperties.existsBinaryBuildEntry((IResource)checkFolder)) {
                return;
            }
            checkFolder = checkFolder.getParent();
        }
        String fld = this.getTranslationFolder();
        if (!fld.endsWith("/")) {
            fld = String.valueOf(fld) + "/";
        }
        pmh.BuildProperties.addBinaryBuildEntry(fld);
        pmh.save();
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        this.getJavaProject().getProject().refreshLocal(2, monitor);
        this.createLanguageFiles(monitor);
        this.addBuildEntry();
        ServiceNewOperation serviceOp = new ServiceNewOperation(null, this.getServiceName());
        serviceOp.setImplementationProject(this.getJavaProject());
        serviceOp.setImplementationPackageName(this.getPackageName());
        serviceOp.addServiceRegistration(new ServiceRegistrationDescription(this.getJavaProject()));
        serviceOp.setImplementationSuperTypeSignature(SignatureCache.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        IMethodSourceBuilder getDynamicNlsBaseNameBuilder = MethodSourceBuilderFactory.createOverrideMethodSourceBuilder((ITypeSourceBuilder)serviceOp.getImplementationSourceBuilder(), (String)"getDynamicNlsBaseName");
        getDynamicNlsBaseNameBuilder.setMethodBodySourceBuilder(MethodBodySourceBuilderFactory.createSimpleMethodBody((String)("return \"" + CreateSimpleNlsProjectOperation.getResourcePathString((String)this.getTranslationFolder(), (String)this.getTranslationFilePrefix()) + "\";")));
        serviceOp.getImplementationSourceBuilder().addSortedMethodSourceBuilder(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)getDynamicNlsBaseNameBuilder), getDynamicNlsBaseNameBuilder);
        serviceOp.validate();
        serviceOp.run(monitor, workingCopyManager);
        this.m_createdServiceType = serviceOp.getCreatedServiceImplementation();
        TypeUtility.getPrimaryTypeHierarchy((IType)this.getSuperType()).invalidate();
        ResourcesPlugin.getWorkspace().checkpoint(false);
        JdtUtility.waitForIndexesReady();
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public String getTranslationFolder() {
        return this.m_translationFolder;
    }

    public void setTranslationFolder(String translationFolder) {
        this.m_translationFolder = translationFolder;
    }

    public String getTranslationFilePrefix() {
        return this.m_translationFilePrefix;
    }

    public void setTranslationFilePrefix(String translationFilePrefix) {
        this.m_translationFilePrefix = translationFilePrefix;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setLanguages(String[] languages) {
        this.m_languages = languages;
    }

    public String[] getLanguages() {
        return this.m_languages;
    }

    public IType getCreatedServiceType() {
        return this.m_createdServiceType;
    }

    public String getPackageName() {
        return this.m_packageName;
    }
}

