/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.services.ui.page;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.services.model.ws.project.ServiceNlsProjectProvider;
import org.eclipse.scout.nls.sdk.services.ui.action.TextProviderServiceNewAction;
import org.eclipse.scout.nls.sdk.services.ui.page.TextServiceNodePage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.INodeVisitor;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class TextServiceTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_serviceHierarchy;

    public TextServiceTablePage() {
        this.setName(Texts.get((String)"TextProviderServices"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor((String)"texts.png"));
    }

    public void unloadPage() {
        if (this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_serviceHierarchy = null;
        }
        super.unloadPage();
    }

    public void refresh(boolean clearCache) {
        if (clearCache && this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    public String getPageId() {
        return "org.eclipse.scout.sdk.page.TextServiceTablePage";
    }

    public boolean isFolder() {
        return true;
    }

    public int accept(INodeVisitor visitor) {
        return this.visitChildren(visitor);
    }

    public void loadChildrenImpl() {
        if (this.m_serviceHierarchy == null) {
            IType abstractDynamicNlsTextProviderService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.text.AbstractDynamicNlsTextProviderService");
            this.m_serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)abstractDynamicNlsTextProviderService);
            this.m_serviceHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        try {
            IType[] services = ServiceNlsProjectProvider.getRegisteredTextProviderTypes();
            ITypeFilter filter = ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getScoutBundle()});
            IType[] iTypeArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (filter.accept(type)) {
                    new TextServiceNodePage(this, type);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            NlsCore.logWarning((String)"Could not get the text provider service types.", (Throwable)e);
        }
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{TextProviderServiceNewAction.class};
    }

    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof TextProviderServiceNewAction) {
            ((TextProviderServiceNewAction)menu).setScoutBundle(this.getScoutBundle());
        }
    }
}

